/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.topo;

import cz.auderis.tools.collection.topo.TopoCycleException;
import cz.auderis.tools.collection.topo.TopoNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public final class TopoSorter<K, V> {
    private static final String ERR_CYCLE = "input dependency structure contains a cycle";
    private Queue<TopoNode<? extends K, ? extends V>> leadNodes = new LinkedList<TopoNode<? extends K, ? extends V>>();
    private List<TopoNode<? extends K, ? extends V>> dependentNodes = new LinkedList<TopoNode<? extends K, ? extends V>>();
    private List<? super V> result;
    private int startResultIndex;

    public static <K, V> List<V> sort(Collection<? extends TopoNode<? extends K, ? extends V>> sourceNodes) throws TopoCycleException {
        if (null == sourceNodes || sourceNodes.isEmpty()) {
            return new ArrayList();
        }
        int nodeCount = sourceNodes.size();
        ArrayList result = new ArrayList(nodeCount);
        TopoSorter sorter = new TopoSorter(sourceNodes, result);
        super.sort();
        super.checkUnprocessedNodes();
        return result;
    }

    public static <K, V> void sortTo(Collection<? extends TopoNode<? extends K, ? extends V>> sourceNodes, List<? super V> target) throws TopoCycleException {
        if (null == sourceNodes || sourceNodes.isEmpty()) {
            return;
        }
        if (null == target) {
            throw new NullPointerException();
        }
        TopoSorter<K, ? super V> sorter = new TopoSorter<K, V>(sourceNodes, target);
        super.sort();
        super.checkUnprocessedNodes();
    }

    private TopoSorter(Collection<? extends TopoNode<? extends K, ? extends V>> sourceNodes, List<? super V> result) {
        this.result = result;
        this.startResultIndex = result.size();
        for (TopoNode<K, V> node : sourceNodes) {
            if (null == node) continue;
            if (node.getRemainingTopoDependencies().isEmpty()) {
                this.leadNodes.add(node);
                continue;
            }
            this.dependentNodes.add(node);
        }
    }

    private void sort() {
        while (!this.leadNodes.isEmpty()) {
            TopoNode<K, V> leadNode = this.leadNodes.remove();
            this.result.add(leadNode.getValue());
            K currentKey = leadNode.getTopoKey();
            Iterator<TopoNode<K, V>> nodeIter = this.dependentNodes.iterator();
            while (nodeIter.hasNext()) {
                TopoNode<K, V> node = nodeIter.next();
                Set<K> dependencies = node.getRemainingTopoDependencies();
                dependencies.remove(currentKey);
                if (!dependencies.isEmpty()) continue;
                this.leadNodes.add(node);
                nodeIter.remove();
            }
        }
    }

    private void checkUnprocessedNodes() throws TopoCycleException {
        List okValues;
        if (this.dependentNodes.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder(ERR_CYCLE);
        boolean first = true;
        for (TopoNode<K, V> node : this.dependentNodes) {
            if (first) {
                msg.append(" in ");
                first = false;
            } else {
                msg.append(", ");
            }
            msg.append(node.getTopoKey());
            int dependencySeparator = 91;
            for (K remainingDependency : node.getRemainingTopoDependencies()) {
                msg.append((char)dependencySeparator);
                if (91 == dependencySeparator) {
                    dependencySeparator = 44;
                }
                msg.append(remainingDependency);
            }
            msg.append(']');
        }
        if (this.result.size() > this.startResultIndex) {
            List<? super V> addedItems = this.result.subList(this.startResultIndex, this.result.size());
            okValues = new ArrayList<V>(addedItems);
        } else {
            okValues = Collections.emptyList();
        }
        ArrayList<TopoNode<? extends K, ? extends V>> failNodes = new ArrayList<TopoNode<? extends K, ? extends V>>(this.dependentNodes);
        throw new TopoCycleException(msg.toString(), okValues, failNodes);
    }
}

