/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.tuple;

import cz.auderis.tools.collection.tuple.ImmutablePair;
import cz.auderis.tools.collection.tuple.Pair;
import java.util.Map;
import java.util.Objects;

public class AtomicPair<L, R>
extends Pair<L, R> {
    private static final long serialVersionUID = 4954918890077093842L;
    private volatile L left;
    private volatile R right;

    public static <L, R> AtomicPair<L, R> of(L left, R right) {
        return new AtomicPair<L, R>(left, right);
    }

    public static <L, R> AtomicPair<L, R> copyOf(Map.Entry<L, R> source) {
        if (null == source) {
            throw new NullPointerException();
        }
        return new AtomicPair<L, R>(source.getKey(), source.getValue());
    }

    protected AtomicPair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public synchronized L getLeft() {
        return this.left;
    }

    @Override
    public synchronized R getRight() {
        return this.right;
    }

    public synchronized Pair<L, R> get() {
        return new ImmutablePair<L, R>(this.left, this.right);
    }

    public synchronized void setLeft(L left) {
        this.left = left;
    }

    public synchronized void setRight(R right) {
        this.right = right;
    }

    public synchronized L getAndSetLeft(L lt) {
        L oldLeft = lt;
        this.left = lt;
        return oldLeft;
    }

    public synchronized R getAndSetRight(R rt) {
        R oldRight = rt;
        this.right = rt;
        return oldRight;
    }

    public L setKey(L key) {
        return this.getAndSetLeft(key);
    }

    @Override
    public R setValue(R value) {
        return this.getAndSetRight(value);
    }

    public synchronized void set(L lt, R rt) {
        this.left = lt;
        this.right = rt;
    }

    public synchronized boolean compareAndSet(L expectLeft, R expectRight, L newLeft, R newRight) {
        L currLeft = this.left;
        R currRight = this.right;
        boolean leftMatch = Objects.equals(expectLeft, currLeft);
        boolean rightMatch = Objects.equals(expectRight, currRight);
        if (leftMatch && rightMatch) {
            this.left = newLeft;
            this.right = newRight;
            return true;
        }
        return false;
    }

    public synchronized boolean compareLeftAndSet(L expectLeft, L newLeft) {
        if (null == expectLeft != (null == this.left)) {
            return false;
        }
        if (null == this.left || Objects.equals(this.left, expectLeft)) {
            this.left = newLeft;
            return true;
        }
        return false;
    }

    public synchronized boolean compareLeftAndSet(L expectLeft, L newLeft, R newRight) {
        if (null == expectLeft != (null == this.left)) {
            return false;
        }
        if (null == this.left || Objects.equals(this.left, expectLeft)) {
            this.left = newLeft;
            this.right = newRight;
            return true;
        }
        return false;
    }

    public synchronized boolean compareRightAndSet(R expectRight, R newRight) {
        if (null == expectRight != (null == this.right)) {
            return false;
        }
        if (null == this.right || Objects.equals(this.right, expectRight)) {
            this.right = newRight;
            return true;
        }
        return false;
    }

    public synchronized boolean compareRightAndSet(R expectRight, L newLeft, R newRight) {
        if (null == expectRight != (null == this.right)) {
            return false;
        }
        if (null == this.right || Objects.equals(this.right, expectRight)) {
            this.left = newLeft;
            this.right = newRight;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        R currRight;
        L currLeft;
        AtomicPair atomicPair = this;
        synchronized (atomicPair) {
            currLeft = this.left;
            currRight = this.right;
        }
        return (currLeft == null ? 0 : currLeft.hashCode()) ^ (currRight == null ? 0 : currRight.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        R currRight;
        L currLeft;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        AtomicPair atomicPair = this;
        synchronized (atomicPair) {
            currLeft = this.left;
            currRight = this.right;
        }
        if (!Objects.equals(currLeft, other.getKey())) {
            return false;
        }
        return Objects.equals(currRight, other.getValue());
    }
}

