/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.tuple;

import cz.auderis.tools.collection.tuple.Pair;
import java.util.Map;
import java.util.Objects;

public class BasicPair<L, R>
extends Pair<L, R> {
    private static final long serialVersionUID = 4954918890077093842L;
    private L left;
    private R right;

    public static <L, R> BasicPair<L, R> of(L left, R right) {
        return new BasicPair<L, R>(left, right);
    }

    public static <L, R> BasicPair<L, R> copyOf(Map.Entry<L, R> source) {
        if (null == source) {
            throw new NullPointerException();
        }
        return new BasicPair<L, R>(source.getKey(), source.getValue());
    }

    BasicPair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    public L setLeft(L lt) {
        L oldLeft = this.left;
        this.left = lt;
        return oldLeft;
    }

    public R setRight(R rt) {
        R oldRight = this.right;
        this.right = rt;
        return oldRight;
    }

    public L setKey(L key) {
        return this.setLeft(key);
    }

    @Override
    public R setValue(R value) {
        return this.setRight(value);
    }

    @Override
    public int hashCode() {
        return (this.left == null ? 0 : this.left.hashCode()) ^ (this.right == null ? 0 : this.right.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        if (!Objects.equals(this.left, other.getKey())) {
            return false;
        }
        return Objects.equals(this.right, other.getValue());
    }
}

