/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.collection.tuple;

import cz.auderis.tools.collection.tuple.Pair;
import java.util.Map;
import java.util.Objects;

public final class ImmutablePair<L, R>
extends Pair<L, R> {
    private static final long serialVersionUID = 4954918890077093842L;
    private final L left;
    private final R right;

    public static <L, R> ImmutablePair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public static <L, R> ImmutablePair<L, R> copyOf(Map.Entry<L, R> source) {
        if (null == source) {
            throw new NullPointerException();
        }
        return new ImmutablePair<L, R>(source.getKey(), source.getValue());
    }

    ImmutablePair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return (this.left == null ? 0 : this.left.hashCode()) ^ (this.right == null ? 0 : this.right.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        if (!Objects.equals(this.left, other.getKey())) {
            return false;
        }
        return Objects.equals(this.right, other.getValue());
    }
}

