/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config;

import cz.auderis.tools.config.ConfigurationDataAccessProxyHandler;
import cz.auderis.tools.config.ConfigurationDataProvider;
import cz.auderis.tools.config.spi.CompoundDataProvider;
import cz.auderis.tools.config.spi.MapBasedDataProvider;
import cz.auderis.tools.config.spi.SystemPropertyDataProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class ConfigurationData {
    public static ConfigurationDataProvider getSystemPropertyDataProvider() {
        return SystemPropertyDataProvider.instance();
    }

    public static ConfigurationDataProvider getMapDataProvider(Map<String, ?> dataSource) {
        return new MapBasedDataProvider(dataSource);
    }

    public static ConfigurationDataProvider getCompoundDataProvider(ConfigurationDataProvider ... providers) {
        return new CompoundDataProvider(providers);
    }

    public static <T> T createConfigurationObject(ConfigurationDataProvider dataProvider, Class<T> targetClass, ClassLoader clsLoader) {
        Exception firstFailure;
        ConfigurationDataAccessProxyHandler proxyHandler;
        Class[] interfaces;
        block10: {
            ClassLoader targetClassLoader;
            if (null == dataProvider || null == targetClass) {
                throw new NullPointerException();
            }
            interfaces = new Class[]{targetClass};
            proxyHandler = new ConfigurationDataAccessProxyHandler(dataProvider);
            firstFailure = null;
            if (null != clsLoader) {
                try {
                    Object proxy = Proxy.newProxyInstance(clsLoader, interfaces, (InvocationHandler)proxyHandler);
                    return (T)proxy;
                }
                catch (Exception e) {
                    firstFailure = e;
                }
            }
            if ((targetClassLoader = targetClass.getClassLoader()) != clsLoader) {
                try {
                    Object proxy = Proxy.newProxyInstance(targetClassLoader, interfaces, (InvocationHandler)proxyHandler);
                    return (T)proxy;
                }
                catch (Exception e) {
                    if (null != firstFailure) break block10;
                    firstFailure = e;
                }
            }
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object proxy = Proxy.newProxyInstance(contextLoader, interfaces, (InvocationHandler)proxyHandler);
            return (T)proxy;
        }
        catch (Exception e) {
            if (null == firstFailure) {
                firstFailure = e;
            }
            throw new IllegalArgumentException("cannot create proxy class", firstFailure);
        }
    }

    public static <T> T createConfigurationObject(ConfigurationDataProvider dataProvider, Class<T> targetClass) {
        return ConfigurationData.createConfigurationObject(dataProvider, targetClass, null);
    }

    private ConfigurationData() {
        throw new AssertionError();
    }
}

