/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config;

import cz.auderis.tools.config.ConfigurationDataProvider;
import cz.auderis.tools.config.DataTranslator;
import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.StandardJavaTranslator;
import cz.auderis.tools.config.annotation.ConfigurationEntries;
import cz.auderis.tools.config.annotation.ConfigurationEntryName;
import cz.auderis.tools.config.annotation.DefaultConfigurationEntryValue;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ConfigurationDataAccessProxyHandler
implements InvocationHandler {
    private static final String GETTER_PREFIX = "get";
    private static final String GETTER_PREFIX_BOOLEAN = "is";
    private static final Object NULL_CACHE_ENTRY = new Object();
    private final ConfigurationDataProvider dataProvider;
    private final ConcurrentMap<Method, SoftReference<Object>> cache;

    public ConfigurationDataAccessProxyHandler(ConfigurationDataProvider dataProvider) {
        if (null == dataProvider) {
            throw new NullPointerException();
        }
        this.dataProvider = dataProvider;
        this.cache = new ConcurrentHashMap<Method, SoftReference<Object>>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String keyName;
        if (null == args && this.cache.containsKey(method)) {
            SoftReference resultRef = (SoftReference)this.cache.get(method);
            Object result = resultRef.get();
            if (result == NULL_CACHE_ENTRY) {
                return null;
            }
            if (null != result) {
                return result;
            }
            this.cache.remove(method, resultRef);
        }
        Object sourceValue = this.dataProvider.containsKey(keyName = this.getResourceKey(method)) ? this.dataProvider.getRawObject(keyName) : this.getDefaultSourceValue(method);
        Object result = this.translateObject(sourceValue, method, args);
        if (null == args) {
            Object cachedValue = null != result ? result : NULL_CACHE_ENTRY;
            this.cache.put(method, new SoftReference<Object>(cachedValue));
        }
        return result;
    }

    private Object getDefaultSourceValue(Method method) {
        String result;
        DefaultConfigurationEntryValue defaultValAnnotation = method.getAnnotation(DefaultConfigurationEntryValue.class);
        String string = result = null != defaultValAnnotation ? defaultValAnnotation.value() : null;
        if (null != result && result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private Object translateObject(Object sourceValue, Method method, Object[] args) {
        Class<?> returnType = method.getReturnType();
        if (String.class == returnType) {
            String textResult = this.translateToString(sourceValue, args);
            return textResult;
        }
        StandardJavaTranslator standardTranslator = StandardJavaTranslator.instance();
        if (standardTranslator.isPrimitiveOrBoxed(returnType)) {
            Object primitiveResult = standardTranslator.translatePrimitive(sourceValue, returnType);
            return primitiveResult;
        }
        if (returnType.isEnum()) {
            Object enumResult = standardTranslator.translateEnum(sourceValue, returnType);
            return enumResult;
        }
        Object pluginResult = this.tryPluginTranslator(sourceValue, returnType, method, args);
        if (null != pluginResult) {
            return DataTranslator.NULL_OBJECT != pluginResult ? pluginResult : null;
        }
        Object constructedResult = this.tryConstruct(sourceValue, returnType, args);
        if (null != constructedResult) {
            return constructedResult;
        }
        if (null != sourceValue && Class.class == returnType && sourceValue instanceof String) {
            try {
                Class<?> classResult = Class.forName((String)sourceValue);
                return classResult;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    private String translateToString(Object sourceValue, Object[] args) {
        if (null == sourceValue) {
            return "";
        }
        if (sourceValue instanceof String) {
            if (null != args) {
                try {
                    return MessageFormat.format((String)sourceValue, args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (String)sourceValue;
        }
        return sourceValue.toString();
    }

    private Object tryPluginTranslator(Object sourceValue, Class targetClass, AnnotatedElement element, Object[] args) {
        ServiceLoader<DataTranslator> translators = ServiceLoader.load(DataTranslator.class);
        Iterator<DataTranslator> translatorIterator = translators.iterator();
        ArrayList<TranslatorCandidate> applicableTranslators = new ArrayList<TranslatorCandidate>(2);
        while (true) {
            boolean hasNext;
            try {
                hasNext = translatorIterator.hasNext();
            }
            catch (ServiceConfigurationError e) {
                hasNext = false;
            }
            if (!hasNext) break;
            try {
                DataTranslator translator = translatorIterator.next();
                int supportPriority = translator.getTargetClassSupportPriority(targetClass);
                if (supportPriority <= 0) continue;
                TranslatorCandidate candidate = new TranslatorCandidate(translator, supportPriority);
                applicableTranslators.add(candidate);
            }
            catch (Exception e) {}
        }
        if (!applicableTranslators.isEmpty()) {
            Collections.sort(applicableTranslators);
            DataTranslatorContextImpl context = new DataTranslatorContextImpl(element, args);
            for (TranslatorCandidate candidate : applicableTranslators) {
                try {
                    DataTranslator selectedTranslator = candidate.translator;
                    Object result = selectedTranslator.translateToClass(sourceValue, targetClass, context);
                    if (null == result) continue;
                    return result;
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    private Object tryConstruct(Object sourceValue, Class<?> returnType, Object[] args) {
        if (null == sourceValue) {
            return null;
        }
        try {
            Constructor<?>[] constructors;
            if (null == args) {
                Object[] paramRef = new Object[]{sourceValue};
                Constructor<?> constructor = this.findSingleArgumentConstructor(returnType, paramRef);
                Object result = constructor.newInstance(paramRef[0]);
                return result;
            }
            Class[] argumentTypes = new Class[1 + args.length];
            argumentTypes[0] = sourceValue.getClass();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Class<?> argClass = null == arg ? null : arg.getClass();
                argumentTypes[i + 1] = argClass;
            }
            for (Constructor<?> constructor : constructors = returnType.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                boolean paramMatch = this.matchParameters(parameterTypes, argumentTypes);
                if (!paramMatch) continue;
                Object[] extArgs = new Object[1 + args.length];
                extArgs[0] = sourceValue;
                for (int i = 0; i < args.length; ++i) {
                    extArgs[i + 1] = args[0];
                }
                Object result = constructor.newInstance(extArgs);
                return result;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Constructor<?> findSingleArgumentConstructor(Class<?> type, Object[] paramRef) {
        Object param = paramRef[0];
        Class<?> paramClass = param.getClass();
        try {
            Constructor<?> constructor = type.getConstructor(paramClass);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Class<?> altParamClass = StandardJavaTranslator.instance().switchPrimitiveAndBoxedType(paramClass);
            if (null != altParamClass) {
                try {
                    Constructor<?> constructor = type.getConstructor(altParamClass);
                    return constructor;
                }
                catch (NoSuchMethodException e2) {
                    // empty catch block
                }
            }
            if (String.class == paramClass) {
                String textParam = (String)param;
                StandardJavaTranslator stdTranslator = StandardJavaTranslator.instance();
                for (Constructor<?> candidate : type.getConstructors()) {
                    Object convertedParam;
                    Class<?> argType;
                    Class<?>[] candidateArgTypes = candidate.getParameterTypes();
                    if (1 != candidateArgTypes.length || !stdTranslator.isPrimitiveOrBoxed(argType = candidateArgTypes[0]) || null == (convertedParam = stdTranslator.translatePrimitive(textParam, argType))) continue;
                    paramRef[0] = convertedParam;
                    return candidate;
                }
            }
            return null;
        }
    }

    private boolean matchParameters(Class<?>[] parameterTypes, Class[] argumentTypes) {
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            Class argType = argumentTypes[i];
            if (!(null == argType ? paramType.isPrimitive() : !paramType.isAssignableFrom(argType))) continue;
            return false;
        }
        return true;
    }

    private String getResourceKey(Method method) {
        String keyPrefix = this.getResourceKeyPrefix(method);
        ConfigurationEntryName nameAnnotation = method.getAnnotation(ConfigurationEntryName.class);
        if (null != nameAnnotation) {
            boolean keyNameDefined;
            String keyName = nameAnnotation.name();
            boolean bl = keyNameDefined = null != keyName && !keyName.isEmpty();
            if (keyNameDefined && this.dataProvider.containsKey(keyPrefix + keyName)) {
                return keyPrefix + keyName;
            }
            String[] keyAliases = nameAnnotation.alias();
            if (null != keyAliases && 0 != keyAliases.length) {
                for (String alias : keyAliases) {
                    if (null == alias || alias.isEmpty() || !this.dataProvider.containsKey(keyPrefix + alias)) continue;
                    return keyPrefix + alias;
                }
            }
            if (keyNameDefined) {
                return keyPrefix + keyName;
            }
        }
        String methodName = method.getName();
        boolean booleanGetter = this.isBasicBooleanGetter(method);
        String keyName = this.trimOptionalGetterPrefix(methodName, booleanGetter);
        return keyPrefix + keyName;
    }

    private String getResourceKeyPrefix(Member method) {
        Class<?> declaringClass = method.getDeclaringClass();
        ConfigurationEntries prefixAnnotation = declaringClass.getAnnotation(ConfigurationEntries.class);
        if (null == prefixAnnotation) {
            return "";
        }
        String explicitPrefix = prefixAnnotation.prefix();
        if (null == explicitPrefix || explicitPrefix.trim().isEmpty()) {
            return "";
        }
        StringBuilder resultPrefix = new StringBuilder();
        if ("*".equals(explicitPrefix)) {
            resultPrefix.append(declaringClass.getSimpleName());
        } else {
            resultPrefix.append(explicitPrefix);
        }
        if (resultPrefix.charAt(resultPrefix.length() - 1) != '.') {
            resultPrefix.append('.');
        }
        return resultPrefix.toString();
    }

    private String trimOptionalGetterPrefix(String methodName, boolean considerBooleanPrefix) {
        String prefix;
        if (methodName.startsWith(GETTER_PREFIX)) {
            prefix = GETTER_PREFIX;
        } else if (considerBooleanPrefix && methodName.startsWith(GETTER_PREFIX_BOOLEAN)) {
            prefix = GETTER_PREFIX_BOOLEAN;
        } else {
            return methodName;
        }
        String propertyName = methodName.substring(prefix.length());
        char firstChar = propertyName.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            return methodName;
        }
        return Character.toLowerCase(firstChar) + propertyName.substring(1);
    }

    private boolean isBasicBooleanGetter(Method method) {
        Class<?> resultType = method.getReturnType();
        if (Boolean.TYPE != resultType) {
            return false;
        }
        return 0 == method.getParameterTypes().length;
    }

    protected static final class DataTranslatorContextImpl
    implements DataTranslatorContext {
        private final AnnotatedElement element;
        private final Object[] arguments;

        public DataTranslatorContextImpl(AnnotatedElement element, Object[] arguments) {
            this.element = element;
            this.arguments = arguments;
        }

        @Override
        public AnnotatedElement getTargetElement() {
            return this.element;
        }

        @Override
        public Object[] getTargetArguments() {
            return this.arguments;
        }
    }

    protected static final class TranslatorCandidate
    implements Comparable<TranslatorCandidate> {
        final DataTranslator translator;
        final int priority;

        public TranslatorCandidate(DataTranslator translator, int priority) {
            this.translator = translator;
            this.priority = priority;
        }

        @Override
        public int compareTo(TranslatorCandidate other) {
            return other.priority - this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TranslatorCandidate candidate = (TranslatorCandidate)o;
            if (this.priority != candidate.priority) {
                return false;
            }
            return this.translator.equals(candidate.translator);
        }

        public int hashCode() {
            return this.priority;
        }
    }
}

