/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StandardJavaTranslator {
    private static final StandardJavaTranslator INSTANCE = new StandardJavaTranslator();
    private final Map<Class<?>, PrimitiveTranslator> primitiveTranslatorMap = new HashMap();
    private final Map<Class<?>, Class<?>> primitiveToBoxedMap = new HashMap();
    private final Map<Class<?>, Class<?>> boxedToPrimitiveMap = new HashMap();

    public static StandardJavaTranslator instance() {
        return INSTANCE;
    }

    public boolean isPrimitiveOrBoxed(Class<?> targetType) {
        return this.primitiveTranslatorMap.containsKey(targetType);
    }

    public Class<?> switchPrimitiveAndBoxedType(Class<?> type) {
        if (type.isPrimitive()) {
            return this.primitiveToBoxedMap.get(type);
        }
        return this.boxedToPrimitiveMap.get(type);
    }

    public Object translatePrimitive(Object source, Class<?> resourceType) {
        PrimitiveTranslator translator = this.primitiveTranslatorMap.get(resourceType);
        if (null == translator) {
            return null;
        }
        try {
            if (null != source && translator.getSupportedClasses().contains(source.getClass())) {
                return source;
            }
            if (source instanceof String) {
                return translator.translateString((String)source);
            }
            if (resourceType.isPrimitive()) {
                return translator.defaultValue();
            }
            return translator.translate(source);
        }
        catch (Exception e) {
            return translator.defaultValue();
        }
    }

    public Object translateEnum(Object sourceValue, Class<?> returnType) {
        if (null == sourceValue) {
            return null;
        }
        if (returnType.isAssignableFrom(sourceValue.getClass())) {
            return sourceValue;
        }
        if (sourceValue instanceof String) {
            String enumName = (String)sourceValue;
            for (Object enumObj : returnType.getEnumConstants()) {
                Enum enumConst = (Enum)enumObj;
                if (!enumName.equalsIgnoreCase(enumConst.name())) continue;
                return enumConst;
            }
        }
        return null;
    }

    private StandardJavaTranslator() {
        for (PrimitiveTranslator tx : PrimitiveTranslator.values()) {
            List<Class<?>> supportedClasses = tx.getSupportedClasses();
            for (Class<?> supportedClass : supportedClasses) {
                this.primitiveTranslatorMap.put(supportedClass, tx);
            }
            Class<?> primitiveType = supportedClasses.get(1);
            Class<?> boxedType = supportedClasses.get(0);
            this.primitiveToBoxedMap.put(primitiveType, boxedType);
            this.boxedToPrimitiveMap.put(boxedType, primitiveType);
        }
    }

    static enum PrimitiveTranslator {
        BOOLEAN{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Boolean.class, Boolean.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Boolean.parseBoolean(source);
            }

            @Override
            public Object defaultValue() {
                return false;
            }
        }
        ,
        BYTE{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Byte.class, Byte.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Byte.parseByte(source);
            }

            @Override
            public Object defaultValue() {
                return (byte)0;
            }
        }
        ,
        SHORT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Short.class, Short.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Short.parseShort(source);
            }

            @Override
            public Object defaultValue() {
                return (short)0;
            }
        }
        ,
        INT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Integer.class, Integer.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Integer.parseInt(source);
            }

            @Override
            public Object defaultValue() {
                return 0;
            }
        }
        ,
        LONG{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Long.class, Long.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Long.parseLong(source);
            }

            @Override
            public Object defaultValue() {
                return 0L;
            }
        }
        ,
        FLOAT{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Float.class, Float.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Float.valueOf(Float.parseFloat(source));
            }

            @Override
            public Object defaultValue() {
                return Float.valueOf(0.0f);
            }
        }
        ,
        DOUBLE{

            @Override
            public List<Class<?>> getSupportedClasses() {
                return Arrays.asList(Double.class, Double.TYPE);
            }

            @Override
            public Object translateString(String source) {
                return Double.parseDouble(source);
            }

            @Override
            public Object defaultValue() {
                return 0.0;
            }
        };


        public abstract List<Class<?>> getSupportedClasses();

        public abstract Object defaultValue();

        public abstract Object translateString(String var1);

        public Object translate(Object source) {
            return null;
        }
    }
}

