/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.config.spi;

import cz.auderis.tools.config.DataTranslatorContext;
import cz.auderis.tools.config.annotation.PatternMode;
import cz.auderis.tools.config.spi.SingleTargetClassTranslator;
import java.lang.reflect.AnnotatedElement;
import java.util.regex.Pattern;

public class PatternTranslator
extends SingleTargetClassTranslator {
    public PatternTranslator() {
        super(Pattern.class);
    }

    @Override
    public String getId() {
        return "pattern translator";
    }

    @Override
    protected Object translate(Object source, DataTranslatorContext context) {
        if (source instanceof String) {
            int regexFlags = this.determinePatternMode(context);
            try {
                Pattern pattern = Pattern.compile((String)source, regexFlags);
                return pattern;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private int determinePatternMode(DataTranslatorContext context) {
        AnnotatedElement element = null != context ? context.getTargetElement() : null;
        PatternMode modeAnnotation = element != null ? element.getAnnotation(PatternMode.class) : null;
        int mode = null != modeAnnotation ? modeAnnotation.value() : 0;
        return mode;
    }
}

