/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.lang;

public class AppendableCharArrayWrapper
implements Appendable,
CharSequence {
    private final char[] target;
    private final int capacity;
    private final int minIndex;
    private final int maxIndex;
    private final int length;
    private final char zeroReplacement;
    private int offset;

    public AppendableCharArrayWrapper(char[] wrappedArray, int offset, int length, char zeroReplacement) {
        if (null == wrappedArray) {
            throw new NullPointerException();
        }
        this.target = wrappedArray;
        this.capacity = this.target.length;
        if (offset < 0 || offset >= this.capacity) {
            throw new IndexOutOfBoundsException("invalid offset");
        }
        this.minIndex = offset;
        if (length < 0 || this.minIndex + length > this.capacity) {
            throw new IllegalArgumentException("invalid length");
        }
        this.length = length;
        this.maxIndex = this.minIndex + length - 1;
        this.offset = this.minIndex;
        this.zeroReplacement = zeroReplacement;
    }

    public AppendableCharArrayWrapper(char[] wrappedArray, int offset, int length) {
        this(wrappedArray, offset, length, '\u0000');
    }

    public AppendableCharArrayWrapper(char[] wrappedArray) {
        this(wrappedArray, 0, null != wrappedArray ? wrappedArray.length : 0, '\u0000');
    }

    @Override
    public Appendable append(char c) {
        if (this.offset <= this.maxIndex) {
            this.target[this.offset++] = c;
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) {
        if (null == csq) {
            return this;
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int srcStart, int srcEnd) {
        if (null == csq || srcEnd == srcStart) {
            return this;
        }
        if (srcStart < 0 || srcStart >= csq.length()) {
            throw new IndexOutOfBoundsException("bad start index");
        }
        if (srcEnd < srcStart || srcEnd > csq.length()) {
            throw new IndexOutOfBoundsException("bad end index");
        }
        int srcLen = srcEnd - srcStart;
        if (this.offset + srcLen > this.maxIndex + 1) {
            srcLen = this.maxIndex + 1 - this.offset;
        }
        for (int i = 0; i < srcLen; ++i) {
            char c = csq.charAt(i);
            this.target[this.offset++] = '\u0000' != c ? c : this.zeroReplacement;
        }
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.target[this.minIndex + index];
    }

    public void setCharAt(int index, char c) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.target[this.minIndex + index] = '\u0000' != c ? c : this.zeroReplacement;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length) {
            throw new IndexOutOfBoundsException("bad start index");
        }
        if (end < start || end > this.length) {
            throw new IndexOutOfBoundsException("bad end index");
        }
        int subseqLen = end - start;
        return new AppendableCharArrayWrapper(this.target, this.minIndex + start, subseqLen);
    }

    @Override
    public String toString() {
        String result = new String(this.target, this.minIndex, this.length);
        result = result.intern();
        return result;
    }

    public int getCurrentOffset() {
        return this.offset - this.minIndex;
    }

    public void setCurrentOffset(int newOffset) {
        if (newOffset < 0 || newOffset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = this.minIndex + newOffset;
    }

    public void clear(char clearChar) {
        if ('\u0000' == clearChar) {
            clearChar = this.zeroReplacement;
        }
        for (int i = this.minIndex; i <= this.maxIndex; ++i) {
            this.target[i] = clearChar;
        }
        this.offset = this.minIndex;
    }

    public void clear() {
        this.clear(this.zeroReplacement);
    }
}

