/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.lang;

public final class BooleanStyle {
    private StyleImpl delegate;
    private boolean blankFalse;

    public static Boolean toBoolean(Object obj) {
        if (null == obj) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return 0 != num.intValue();
        }
        if (obj instanceof String) {
            String textVal = ((String)obj).trim();
            for (BasicStyleImpl style : BasicStyleImpl.values()) {
                if (!style.isTrue(textVal)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean toNullableBoolean(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return 0 != num.intValue();
        }
        if (obj instanceof String) {
            String textVal = ((String)obj).trim();
            if (textVal.matches("")) {
                return Boolean.FALSE;
            }
            for (BasicStyleImpl style : BasicStyleImpl.values()) {
                if (style.isTrue(textVal)) {
                    return Boolean.TRUE;
                }
                if (!style.isFalse(textVal)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static BooleanStyle trueFalse() {
        return new BooleanStyle(BasicStyleImpl.TRUE_FALSE);
    }

    public static BooleanStyle yesNo() {
        return new BooleanStyle(BasicStyleImpl.YES_NO);
    }

    public static BooleanStyle onOff() {
        return new BooleanStyle(BasicStyleImpl.ON_OFF);
    }

    public static BooleanStyle numeric() {
        return new BooleanStyle(BasicStyleImpl.NUMERIC);
    }

    public static BooleanStyle custom(String trueMark, String falseMark) {
        return new BooleanStyle(new CustomStyleImpl(trueMark, falseMark));
    }

    public BooleanStyle shortStyle() {
        this.delegate = this.delegate.getShortVersion();
        return this;
    }

    public BooleanStyle longStyle() {
        this.delegate = this.delegate.getLongVersion();
        return this;
    }

    public BooleanStyle explicitFalse() {
        this.blankFalse = false;
        return this;
    }

    public BooleanStyle blankFalse() {
        this.blankFalse = true;
        return this;
    }

    public Boolean fromString(String value) {
        String trimmed;
        String string = trimmed = null != value ? value.trim() : null;
        if (null == trimmed || trimmed.isEmpty()) {
            return this.blankFalse ? Boolean.FALSE : null;
        }
        return this.delegate.isTrue(value);
    }

    public String toString(boolean value) {
        if (this.blankFalse && !value) {
            return "";
        }
        return this.delegate.getMark(value);
    }

    private BooleanStyle(StyleImpl initialDelegate) {
        this.delegate = initialDelegate;
    }

    static class CustomStyleImpl
    implements StyleImpl {
        private final String trueValue;
        private final String falseValue;

        protected CustomStyleImpl(String tVal, String fVal) {
            this.trueValue = tVal.intern();
            this.falseValue = fVal.intern();
        }

        @Override
        public String getMark(boolean value) {
            return value ? this.trueValue : this.falseValue;
        }

        @Override
        public boolean isTrue(String textValue) {
            return this.trueValue.equalsIgnoreCase(textValue);
        }

        @Override
        public boolean isFalse(String textValue) {
            return this.falseValue.equalsIgnoreCase(textValue);
        }

        @Override
        public StyleImpl getShortVersion() {
            return this;
        }

        @Override
        public StyleImpl getLongVersion() {
            return this;
        }
    }

    static enum BasicStyleImpl implements StyleImpl
    {
        TRUE_FALSE{

            @Override
            public String getMark(boolean value) {
                return value ? "true" : "false";
            }

            @Override
            public boolean isTrue(String textValue) {
                return "true".equalsIgnoreCase(textValue);
            }

            @Override
            public boolean isFalse(String textValue) {
                return "false".equalsIgnoreCase(textValue);
            }

            @Override
            public StyleImpl getShortVersion() {
                return SHORT_TRUE_FALSE;
            }

            @Override
            public StyleImpl getLongVersion() {
                return this;
            }
        }
        ,
        SHORT_TRUE_FALSE{

            @Override
            public String getMark(boolean value) {
                return value ? "t" : "f";
            }

            @Override
            public boolean isTrue(String textValue) {
                return "t".equalsIgnoreCase(textValue);
            }

            @Override
            public boolean isFalse(String textValue) {
                return "f".equalsIgnoreCase(textValue);
            }

            @Override
            public StyleImpl getShortVersion() {
                return this;
            }

            @Override
            public StyleImpl getLongVersion() {
                return TRUE_FALSE;
            }
        }
        ,
        YES_NO{

            @Override
            public String getMark(boolean value) {
                return value ? "yes" : "no";
            }

            @Override
            public boolean isTrue(String textValue) {
                return "yes".equalsIgnoreCase(textValue);
            }

            @Override
            public boolean isFalse(String textValue) {
                return "no".equalsIgnoreCase(textValue);
            }

            @Override
            public StyleImpl getShortVersion() {
                return SHORT_YES_NO;
            }

            @Override
            public StyleImpl getLongVersion() {
                return this;
            }
        }
        ,
        SHORT_YES_NO{

            @Override
            public String getMark(boolean value) {
                return value ? "y" : "n";
            }

            @Override
            public boolean isTrue(String textValue) {
                return "y".equalsIgnoreCase(textValue);
            }

            @Override
            public boolean isFalse(String textValue) {
                return "n".equalsIgnoreCase(textValue);
            }

            @Override
            public StyleImpl getShortVersion() {
                return this;
            }

            @Override
            public StyleImpl getLongVersion() {
                return TRUE_FALSE;
            }
        }
        ,
        ON_OFF{

            @Override
            public String getMark(boolean value) {
                return value ? "on" : "off";
            }

            @Override
            public boolean isTrue(String textValue) {
                return "on".equalsIgnoreCase(textValue);
            }

            @Override
            public boolean isFalse(String textValue) {
                return "off".equalsIgnoreCase(textValue);
            }

            @Override
            public StyleImpl getShortVersion() {
                return this;
            }

            @Override
            public StyleImpl getLongVersion() {
                return this;
            }
        }
        ,
        NUMERIC{

            @Override
            public String getMark(boolean value) {
                return value ? "1" : "0";
            }

            @Override
            public boolean isTrue(String textValue) {
                return null != textValue && textValue.matches("^[+-]?\\d*[1-9]\\d*$");
            }

            @Override
            public boolean isFalse(String textValue) {
                return null != textValue && textValue.matches("^-?0+$");
            }

            @Override
            public StyleImpl getShortVersion() {
                return this;
            }

            @Override
            public StyleImpl getLongVersion() {
                return this;
            }
        };

    }

    static interface StyleImpl {
        public String getMark(boolean var1);

        public boolean isTrue(String var1);

        public boolean isFalse(String var1);

        public StyleImpl getShortVersion();

        public StyleImpl getLongVersion();
    }
}

