/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.lang;

import cz.auderis.tools.lang.DefaultMemberFilter;
import cz.auderis.tools.lang.MemberFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ReflectionUtils {
    private static final MemberFilter[] EMPTY_FILTER_ARRAY = new MemberFilter[0];

    public static List<Field> getNormalFields(Class<?> cls) {
        return ReflectionUtils.getFields(cls, DefaultMemberFilter.NORMAL_FIELDS);
    }

    public static List<Field> getFields(Class<?> cls, MemberFilter ... filters) {
        if (null == cls) {
            throw new NullPointerException();
        }
        if (null == filters) {
            filters = EMPTY_FILTER_ARRAY;
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> currCls = cls; null != currCls; currCls = currCls.getSuperclass()) {
            Field[] classFields;
            block1: for (Field f : classFields = currCls.getDeclaredFields()) {
                for (MemberFilter filter : filters) {
                    if (!filter.accept(f, currCls, cls)) continue block1;
                }
                result.add(f);
            }
        }
        return result;
    }

    public static List<Method> getNormalMethods(Class<?> cls) {
        return ReflectionUtils.getMethods(cls, DefaultMemberFilter.NORMAL_METHODS);
    }

    public static List<Method> getMethods(Class<?> cls, MemberFilter ... filters) {
        if (null == cls) {
            throw new NullPointerException();
        }
        if (null == filters) {
            filters = EMPTY_FILTER_ARRAY;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> currCls = cls; null != currCls; currCls = currCls.getSuperclass()) {
            Method[] classMethods;
            block1: for (Method m : classMethods = currCls.getDeclaredMethods()) {
                for (MemberFilter filter : filters) {
                    if (!filter.accept(m, currCls, cls)) continue block1;
                }
                result.add(m);
            }
        }
        return result;
    }

    public static Field getNormalField(Class<?> cls, String fieldName) {
        if (null == cls || null == fieldName) {
            throw new NullPointerException();
        }
        while (null != cls) {
            try {
                int modifiers;
                Field f = cls.getDeclaredField(fieldName);
                if (!(null == f || f.isSynthetic() || Modifier.isStatic(modifiers = f.getModifiers()) || Modifier.isFinal(modifiers))) {
                    return f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Set<String> getMemberNames(Collection<? extends Member> memberCollection) {
        if (null == memberCollection) {
            throw new NullPointerException();
        }
        if (memberCollection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(memberCollection.size());
        for (Member member : memberCollection) {
            if (null == member) continue;
            result.add(member.getName());
        }
        return result;
    }

    private ReflectionUtils() {
        throw new AssertionError();
    }
}

