/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.math;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class BoxedNumbers {
    public static final Set<Class<? extends Number>> INTEGER_CLASSES;
    public static final Set<? extends Class<?>> FLOAT_CLASSES;

    public static boolean isBoxedNumberClass(Class<?> cls) {
        if (null == cls) {
            throw new NullPointerException();
        }
        return INTEGER_CLASSES.contains(cls) || FLOAT_CLASSES.contains(cls);
    }

    public static boolean isBoxedNumber(Object value) {
        if (null == value) {
            return false;
        }
        return BoxedNumbers.isBoxedNumberClass(value.getClass());
    }

    public static boolean isConvertible(Class<?> fromClass, Class<?> toClass) {
        if (null == fromClass || null == toClass) {
            throw new NullPointerException();
        }
        if (INTEGER_CLASSES.contains(fromClass) && INTEGER_CLASSES.contains(toClass)) {
            return true;
        }
        return FLOAT_CLASSES.contains(fromClass) && FLOAT_CLASSES.contains(toClass);
    }

    public static <T> T convertSafely(Object value, Class<T> toClass) {
        if (null == toClass) {
            throw new NullPointerException();
        }
        if (null == value) {
            return null;
        }
        Class<?> fromClass = value.getClass();
        if (!BoxedNumbers.isConvertible(fromClass, toClass)) {
            return null;
        }
        if (INTEGER_CLASSES.contains(fromClass) && INTEGER_CLASSES.contains(toClass)) {
            return BoxedNumbers.fromLong(BoxedNumbers.toLong(value, fromClass), toClass);
        }
        if (FLOAT_CLASSES.contains(fromClass) && FLOAT_CLASSES.contains(toClass)) {
            return BoxedNumbers.fromDouble(BoxedNumbers.toDouble(value, fromClass), toClass);
        }
        throw new IllegalArgumentException("unable to convert from " + fromClass + " to " + toClass);
    }

    private static long toLong(Object value, Class<?> fromClass) {
        long result = fromClass.equals(Byte.class) ? ((Byte)value).longValue() : (fromClass.equals(Short.class) ? ((Short)value).longValue() : (fromClass.equals(Integer.class) ? ((Integer)value).longValue() : ((Long)value).longValue()));
        return result;
    }

    private static <T> T fromLong(long value, Class<T> toClass) {
        Number result = toClass.equals(Byte.class) ? (Number)((byte)value) : (Number)(toClass.equals(Short.class) ? (Number)((short)value) : (Number)(toClass.equals(Integer.class) ? (Number)((int)value) : (Number)value));
        return (T)result;
    }

    private static double toDouble(Object value, Class<?> fromClass) {
        double result = fromClass.equals(Float.class) ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
        return result;
    }

    private static <T> T fromDouble(double value, Class<T> toClass) {
        Number result = toClass.equals(Float.class) ? (Number)Float.valueOf((float)value) : (Number)value;
        return (T)result;
    }

    private BoxedNumbers() {
        throw new AssertionError();
    }

    static {
        HashSet<Class> intClasses = new HashSet<Class>(4);
        HashSet<Class> floatClasses = new HashSet<Class>(2);
        intClasses.addAll(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class));
        floatClasses.addAll(Arrays.asList(Float.class, Double.class));
        INTEGER_CLASSES = Collections.unmodifiableSet(intClasses);
        FLOAT_CLASSES = Collections.unmodifiableSet(floatClasses);
    }
}

