/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.math;

import java.math.BigDecimal;

public final class Round {
    private static final double HALF_FACTOR = 0.5;
    private static final String BAD_FRACTION = "split fraction must be between 0.0 and 1.0";
    private static final String NONPOSITIVE_BASE_STEP = "base step must be a positive number";

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static BigDecimal floor(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 3);
    }

    public static double floor(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return baseStep * Math.floor(x / baseStep);
    }

    public static BigDecimal floor(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 3));
    }

    public static double ceiling(double x) {
        return Math.ceil(x);
    }

    public static BigDecimal ceiling(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 2);
    }

    public static double ceiling(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return baseStep * Math.ceil(x / baseStep);
    }

    public static BigDecimal ceiling(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 2));
    }

    public static double truncFromZero(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return x >= 0.0 ? Math.ceil(x) : Math.floor(x);
    }

    public static BigDecimal truncFromZero(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 0);
    }

    public static double truncFromZero(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.ceil(x / baseStep);
        }
        return baseStep * Math.floor(x / baseStep);
    }

    public static BigDecimal truncFromZero(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 0));
    }

    public static double truncTowardsZero(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return x >= 0.0 ? Math.floor(x) : Math.ceil(x);
    }

    public static BigDecimal truncTowardsZero(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 1);
    }

    public static double truncTowardsZero(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.floor(x / baseStep);
        }
        return baseStep * Math.ceil(x / baseStep);
    }

    public static BigDecimal truncTowardsZero(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 1));
    }

    public static double halfFromZero(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return Math.floor(x + 0.5);
        }
        return Math.ceil(x - 0.5);
    }

    public static BigDecimal halfFromZero(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 4);
    }

    public static double halfFromZero(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.floor(x / baseStep + 0.5);
        }
        return baseStep * Math.ceil(x / baseStep - 0.5);
    }

    public static BigDecimal halfFromZero(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 4));
    }

    public static double halfTowardsZero(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return Math.ceil(x - 0.5);
        }
        return Math.floor(x + 0.5);
    }

    public static BigDecimal halfTowardsZero(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        return x.divide(BigDecimal.ONE, 0, 5);
    }

    public static double halfTowardsZero(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.ceil(x / baseStep - 0.5);
        }
        return baseStep * Math.floor(x / baseStep + 0.5);
    }

    public static BigDecimal halfTowardsZero(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        return baseStep.multiply(x.divide(baseStep, 0, 5));
    }

    public static double halfUp(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return Math.floor(x + 0.5);
    }

    public static BigDecimal halfUp(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        int roundMode = x.signum() >= 0 ? 4 : 5;
        return x.divide(BigDecimal.ONE, 0, roundMode);
    }

    public static double halfUp(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return baseStep * Math.floor(x / baseStep + 0.5);
    }

    public static BigDecimal halfUp(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        int roundMode = x.signum() >= 0 ? 4 : 5;
        return baseStep.multiply(x.divide(baseStep, 0, roundMode));
    }

    public static double halfDown(double x) {
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return Math.ceil(x - 0.5);
    }

    public static BigDecimal halfDown(BigDecimal x) {
        if (null == x) {
            throw new NullPointerException();
        }
        int roundMode = x.signum() >= 0 ? 5 : 4;
        return x.divide(BigDecimal.ONE, 0, roundMode);
    }

    public static double halfDown(double x, double baseStep) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        return baseStep * Math.ceil(x / baseStep - 0.5);
    }

    public static BigDecimal halfDown(BigDecimal x, BigDecimal baseStep) {
        if (null == x || null == baseStep) {
            throw new NullPointerException();
        }
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        int roundMode = x.signum() >= 0 ? 5 : 4;
        return baseStep.multiply(x.divide(baseStep, 0, roundMode));
    }

    public static double partFromZero(double x, double baseStep, double splitFraction) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isFraction(splitFraction)) {
            throw new IllegalArgumentException(BAD_FRACTION);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.floor(x / baseStep + 1.0 - splitFraction);
        }
        return baseStep * Math.ceil(x / baseStep - 1.0 + splitFraction);
    }

    public static double partTowardsZero(double x, double baseStep, double splitFraction) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isFraction(splitFraction)) {
            throw new IllegalArgumentException(BAD_FRACTION);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= 0.0) {
            return baseStep * Math.ceil(x / baseStep - splitFraction);
        }
        return baseStep * Math.floor(x / baseStep + splitFraction);
    }

    public static double partFromMidpoint(double x, double baseStep, double splitFraction, double midpoint) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isFraction(splitFraction)) {
            throw new IllegalArgumentException(BAD_FRACTION);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= midpoint) {
            return baseStep * Math.floor(x / baseStep + 1.0 - splitFraction);
        }
        return baseStep * Math.ceil(x / baseStep - 1.0 + splitFraction);
    }

    public static double partTowardsMidpoint(double x, double baseStep, double splitFraction, double midpoint) {
        if (!Round.isPositiveNumber(baseStep)) {
            throw new IllegalArgumentException(NONPOSITIVE_BASE_STEP);
        }
        if (!Round.isFraction(splitFraction)) {
            throw new IllegalArgumentException(BAD_FRACTION);
        }
        if (!Round.isNormalNumber(x)) {
            return x;
        }
        if (x >= midpoint) {
            return baseStep * Math.ceil(x / baseStep - splitFraction);
        }
        return baseStep * Math.floor(x / baseStep + splitFraction);
    }

    public static double halfFromZeroToEven(double x) {
        boolean floorIsEven;
        if (0.0 == x || !Round.isNormalNumber(x)) {
            return x;
        }
        double offset = 0.0;
        double remainder = x;
        if (x < -9.223372036854776E18 || 9.223372036854776E18 < x) {
            remainder = Math.IEEEremainder(x, 9.223372036854776E18);
            offset = x - remainder;
        }
        boolean bl = floorIsEven = 0L == (1L & (long)Math.floor(remainder));
        if (floorIsEven) {
            return offset + Math.ceil(remainder - 0.5);
        }
        return offset + Math.floor(remainder + 0.5);
    }

    private Round() {
        throw new AssertionError((Object)"utility class, not to be instantiated");
    }

    private static boolean isPositiveNumber(double num) {
        return !Double.isNaN(num) && !Double.isInfinite(num) && !(num <= 0.0);
    }

    private static boolean isPositiveNumber(BigDecimal num) {
        return 0 < num.signum();
    }

    private static boolean isFraction(double num) {
        return !Double.isNaN(num) && !Double.isInfinite(num) && 0.0 < num && num < 1.0;
    }

    private static boolean isNormalNumber(double num) {
        return !Double.isNaN(num) && !Double.isInfinite(num);
    }
}

