/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.math;

import cz.auderis.tools.math.NumberDecomposition;

public final class Scale {
    private static final double BASE_TEN = 10.0;
    private static final double LN10 = Math.log(10.0);

    public static double magnitude(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (Double.isInfinite(x)) {
            return Double.POSITIVE_INFINITY;
        }
        if (0.0 == x) {
            return 0.0;
        }
        return Math.floor(Scale.absLog10(x));
    }

    public static double unitFromNumber(double x) {
        if (Double.isNaN(x)) {
            return x;
        }
        if (Double.isInfinite(x)) {
            return Double.POSITIVE_INFINITY;
        }
        if (0.0 == x) {
            return 1.0;
        }
        return Math.pow(10.0, Math.floor(Scale.absLog10(x)));
    }

    public static double unitFromMagnitude(double mag) {
        if (Double.isNaN(mag)) {
            return mag;
        }
        if (Double.POSITIVE_INFINITY == mag) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.NEGATIVE_INFINITY == mag) {
            return 0.0;
        }
        return Math.pow(10.0, mag);
    }

    public static double normalize(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x) || 0.0 == x) {
            return x;
        }
        double absX = Math.abs(x);
        return absX / Math.pow(10.0, Math.floor(Scale.absLog10(absX)));
    }

    public static NumberDecomposition decompose(double x) {
        double sign;
        if (Double.isNaN(x)) {
            return SpecialDecomposition.NAN;
        }
        if (Double.POSITIVE_INFINITY == x) {
            return SpecialDecomposition.POS_INF;
        }
        if (Double.NEGATIVE_INFINITY == x) {
            return SpecialDecomposition.NEG_INF;
        }
        if (0.0 == x) {
            return SpecialDecomposition.ZERO;
        }
        if (x > 0.0) {
            sign = 1.0;
        } else {
            sign = -1.0;
            x = 0.0 - x;
        }
        double unit = Math.pow(10.0, Math.floor(Scale.absLog10(x)));
        double norm = x / unit;
        return new RegularDecomposition(x, sign, norm, unit);
    }

    private Scale() {
        throw new AssertionError((Object)"utility class, not to be instantiated");
    }

    private static double absLog10(double x) {
        return (x <= 0.0 ? Math.log(0.0 - x) : Math.log(x)) / LN10;
    }

    private static final class RegularDecomposition
    implements NumberDecomposition {
        private final double value;
        private final double sign;
        private final double norm;
        private final double unit;

        protected RegularDecomposition(double value, double sign, double norm, double unit) {
            this.value = value;
            this.sign = sign;
            this.norm = norm;
            this.unit = unit;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public double getSign() {
            return this.sign;
        }

        @Override
        public double getNormalizedValue() {
            return this.norm;
        }

        @Override
        public double getUnit() {
            return this.unit;
        }
    }

    private static enum SpecialDecomposition implements NumberDecomposition
    {
        ZERO{

            @Override
            public double getNormalizedValue() {
                return 0.0;
            }

            @Override
            public double getSign() {
                return 0.0;
            }

            @Override
            public double getUnit() {
                return 1.0;
            }

            @Override
            public double getValue() {
                return 0.0;
            }
        }
        ,
        POS_INF{

            @Override
            public double getNormalizedValue() {
                return 1.0;
            }

            @Override
            public double getSign() {
                return 1.0;
            }

            @Override
            public double getUnit() {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public double getValue() {
                return Double.POSITIVE_INFINITY;
            }
        }
        ,
        NEG_INF{

            @Override
            public double getNormalizedValue() {
                return 1.0;
            }

            @Override
            public double getSign() {
                return -1.0;
            }

            @Override
            public double getUnit() {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public double getValue() {
                return Double.NEGATIVE_INFINITY;
            }
        }
        ,
        NAN{

            @Override
            public double getNormalizedValue() {
                return Double.NaN;
            }

            @Override
            public double getSign() {
                return Double.NaN;
            }

            @Override
            public double getUnit() {
                return Double.NaN;
            }

            @Override
            public double getValue() {
                return Double.NaN;
            }
        };

    }
}

