/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.resource;

import cz.auderis.tools.config.ConfigurationData;
import cz.auderis.tools.config.StandardJavaTranslator;
import cz.auderis.tools.resource.ResourceAccessor;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class ExtResourceBundle
extends ResourceBundle
implements ResourceAccessor {
    public ExtResourceBundle(ResourceBundle decoratedBundle) {
        if (null == decoratedBundle) {
            throw new NullPointerException();
        }
        this.setParent(decoratedBundle);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.parent.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.parent.getLocale();
    }

    @Override
    public Object getRawObject(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return this.getObject(key);
    }

    @Override
    public String getString(String key, String defaultString) {
        if (!this.containsKey(key)) {
            return defaultString;
        }
        return this.getString(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                try {
                    return Integer.parseInt((String)object);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                try {
                    return Long.parseLong((String)object);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
        }
        return defaultValue;
    }

    @Override
    public <T extends Enum<T>> T getEnum(String key, Class<T> enumClass, T defaultValue) {
        if (null == key || null == enumClass) {
            throw new NullPointerException();
        }
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("class is not an enum");
        }
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (enumClass.isAssignableFrom(object.getClass())) {
                return (T)((Enum)enumClass.cast(object));
            }
            if (object instanceof String) {
                Enum[] items;
                String enumName = (String)object;
                for (Enum item : items = (Enum[])enumClass.getEnumConstants()) {
                    if (!item.name().equals(enumName)) continue;
                    return (T)item;
                }
            }
        }
        return defaultValue;
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (object instanceof BigInteger) {
                return (BigInteger)object;
            }
            if (object instanceof Long) {
                return BigInteger.valueOf((Long)object);
            }
            if (object instanceof Integer) {
                return BigInteger.valueOf(((Integer)object).intValue());
            }
            if (object instanceof String) {
                try {
                    return new BigInteger((String)object);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof Long) {
                return BigDecimal.valueOf((Long)object);
            }
            if (object instanceof Integer) {
                return BigDecimal.valueOf(((Integer)object).intValue());
            }
            if (object instanceof String) {
                try {
                    return new BigDecimal((String)object);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public <T> T getObject(String key, Class<T> targetClass, T defaultValue) {
        block7: {
            if (null == key || null == targetClass) {
                throw new NullPointerException();
            }
            if (this.containsKey(key)) {
                Object object = this.getObject(key);
                Class<?> objectClass = object.getClass();
                if (targetClass.isAssignableFrom(objectClass)) {
                    return targetClass.cast(object);
                }
                try {
                    Constructor<T> constructor = targetClass.getConstructor(objectClass);
                    T result = constructor.newInstance(object);
                    return result;
                }
                catch (Exception e) {
                    Class<?> altObjectClass = StandardJavaTranslator.instance().switchPrimitiveAndBoxedType(objectClass);
                    if (null == altObjectClass) break block7;
                    try {
                        Constructor<T> constructor = targetClass.getConstructor(altObjectClass);
                        T result = constructor.newInstance(object);
                        return result;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    @Override
    public <T> T getObjectWithTextDefault(String key, Class<T> targetClass, String defaultTextValue) {
        if (null == key || null == targetClass) {
            throw new NullPointerException();
        }
        if (this.containsKey(key)) {
            Object object = this.getObject(key);
            Class<?> objectClass = object.getClass();
            if (targetClass.isAssignableFrom(objectClass)) {
                return targetClass.cast(object);
            }
            try {
                Constructor<T> constructor = targetClass.getConstructor(objectClass);
                T result = constructor.newInstance(object);
                return result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == defaultTextValue || defaultTextValue.isEmpty()) {
            return null;
        }
        try {
            Constructor<T> constructor = targetClass.getConstructor(String.class);
            T defaultResult = constructor.newInstance(defaultTextValue);
            return defaultResult;
        }
        catch (Exception e) {
            String msg = String.format("Resource (class %s) cannot be constructed from default text value %s: %s", targetClass.getName(), defaultTextValue, e.getMessage());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public <T> T getConfigurationObject(Class<T> configObjectClass, ClassLoader clsLoader) {
        T result = ConfigurationData.createConfigurationObject(this, configObjectClass, clsLoader);
        return result;
    }

    public <T> T getConfigurationObject(Class<T> configObjectClass) {
        T result = ConfigurationData.createConfigurationObject(this, configObjectClass);
        return result;
    }
}

