/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.resource;

import cz.auderis.tools.config.ConfigurationData;
import cz.auderis.tools.resource.EmptyResourceBundle;
import cz.auderis.tools.resource.ExtResourceBundle;
import cz.auderis.tools.resource.SimpleResourceDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceLoader {
    private static final ThreadLocal<ResourceLoader> defaultInstance = new ThreadLocal();
    private final List<ClassLoader> candidateClassLoaders;
    private final Locale targetLocale;
    private final String bundlePackage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLoader instance() {
        ThreadLocal<ResourceLoader> threadLocal = defaultInstance;
        synchronized (threadLocal) {
            ResourceLoader instance = defaultInstance.get();
            if (null == instance) {
                List<ClassLoader> candidates = ResourceLoader.getDefaultClassLoaderCandidates();
                Locale defaultLocale = Locale.getDefault();
                instance = new ResourceLoader(candidates, defaultLocale, null);
                defaultInstance.set(instance);
            }
            return instance;
        }
    }

    public static ResourceLoader instance(ClassLoader clsLoader, Locale locale) {
        if (null == clsLoader && null == locale) {
            return ResourceLoader.instance();
        }
        List<ClassLoader> candidates = null == clsLoader ? ResourceLoader.getDefaultClassLoaderCandidates() : Collections.singletonList(clsLoader);
        if (null == locale) {
            locale = Locale.getDefault();
        }
        return new ResourceLoader(candidates, locale, null);
    }

    public static ResourceLoader forLocale(Locale locale) {
        return ResourceLoader.instance(null, locale);
    }

    public static ResourceLoader forLocale(String language) {
        Locale locale = null == language || language.trim().isEmpty() ? null : new Locale(language);
        return ResourceLoader.instance(null, locale);
    }

    public ResourceLoader withClassLoaders(ClassLoader ... alternatives) {
        if (null == alternatives) {
            throw new NullPointerException();
        }
        if (0 == alternatives.length) {
            throw new IllegalArgumentException("no classloaders were specified");
        }
        List<ClassLoader> candidates = Arrays.asList(alternatives);
        if (candidates.equals(this.candidateClassLoaders)) {
            return this;
        }
        return new ResourceLoader(Collections.unmodifiableList(candidates), this.targetLocale, this.bundlePackage);
    }

    public ResourceLoader withFallbackClassLoaders(ClassLoader ... fallbacks) {
        if (null == fallbacks) {
            throw new NullPointerException();
        }
        if (0 == fallbacks.length) {
            return this;
        }
        int classLoaderCount = this.candidateClassLoaders.size() + fallbacks.length;
        List<ClassLoader> extraCandidates = Arrays.asList(fallbacks);
        ArrayList<ClassLoader> newCandidates = new ArrayList<ClassLoader>(classLoaderCount);
        newCandidates.addAll(this.candidateClassLoaders);
        newCandidates.addAll(extraCandidates);
        return new ResourceLoader(Collections.unmodifiableList(newCandidates), this.targetLocale, this.bundlePackage);
    }

    public ResourceLoader withLocale(Locale newLocale) {
        if (null == newLocale) {
            throw new NullPointerException();
        }
        if (newLocale.equals(this.targetLocale)) {
            return this;
        }
        return new ResourceLoader(this.candidateClassLoaders, newLocale, this.bundlePackage);
    }

    public ResourceLoader withBundlePackage(Package pkg) {
        String newPkgName = null == pkg ? null : pkg.getName();
        if (null == newPkgName ? null == this.bundlePackage : newPkgName.equals(this.bundlePackage)) {
            return this;
        }
        return new ResourceLoader(this.candidateClassLoaders, this.targetLocale, newPkgName);
    }

    public ExtResourceBundle loadResourceBundle(Class forClass) {
        return this.loadResources(forClass, EmptyResourceBundle.extInstance());
    }

    public ExtResourceBundle loadResources(Class forClass, ResourceBundle defaultBundle) {
        if (null == forClass) {
            throw new NullPointerException();
        }
        ResourceBundle foundBundle = this.loadPlainResources(forClass, defaultBundle);
        if (null == foundBundle) {
            return null;
        }
        if (foundBundle instanceof ExtResourceBundle) {
            return (ExtResourceBundle)foundBundle;
        }
        return new ExtResourceBundle(foundBundle);
    }

    public <T> T loadAsConfigurationObject(Class<?> resourceClass, Class<T> cfgObjectClass) {
        return this.loadAsConfigurationObject(resourceClass, cfgObjectClass, EmptyResourceBundle.instance(), null);
    }

    public <T> T loadAsConfigurationObject(Class<?> resourceClass, Class<T> cfgObjectClass, ResourceBundle defaultBundle) {
        return this.loadAsConfigurationObject(resourceClass, cfgObjectClass, defaultBundle, null);
    }

    public <T> T loadAsConfigurationObject(Class<?> resourceClass, Class<T> cfgObjectClass, ResourceBundle defaultBundle, ClassLoader clsLoader) {
        if (null == resourceClass || null == cfgObjectClass) {
            throw new NullPointerException();
        }
        ResourceBundle foundBundle = this.loadPlainResources(resourceClass, defaultBundle);
        SimpleResourceDataProvider dataProvider = null != foundBundle ? new SimpleResourceDataProvider(foundBundle) : new SimpleResourceDataProvider(EmptyResourceBundle.instance());
        T cfgObject = ConfigurationData.createConfigurationObject(dataProvider, cfgObjectClass, clsLoader);
        return cfgObject;
    }

    public ResourceBundle loadPlainResources(Class forClass, ResourceBundle defaultBundle) {
        if (null == forClass) {
            throw new NullPointerException();
        }
        String fullyQualifiedName = this.getQualifiedBundleName(forClass);
        for (ClassLoader loader : this.candidateClassLoaders) {
            ResourceBundle bundle;
            if (null == loader || null == (bundle = ResourceBundle.getBundle(fullyQualifiedName, this.targetLocale, loader))) continue;
            return bundle;
        }
        String simpleName = forClass.getSimpleName();
        for (ClassLoader loader : this.candidateClassLoaders) {
            ResourceBundle bundle;
            if (null == loader || null == (bundle = ResourceBundle.getBundle(simpleName, this.targetLocale, loader))) continue;
            return bundle;
        }
        return defaultBundle;
    }

    private ResourceLoader(List<ClassLoader> candidateClassLoaders, Locale targetLocale, String bundlePackage) {
        this.candidateClassLoaders = candidateClassLoaders;
        this.targetLocale = targetLocale;
        this.bundlePackage = bundlePackage;
    }

    private String getQualifiedBundleName(Class targetClass) {
        if (null == this.bundlePackage) {
            return targetClass.getName();
        }
        String baseClassName = targetClass.getSimpleName();
        return this.bundlePackage + '.' + baseClassName;
    }

    private static List<ClassLoader> getDefaultClassLoaderCandidates() {
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader();
        List<ClassLoader> defaultCandidates = Collections.singletonList(defaultClassLoader);
        return defaultCandidates;
    }
}

