/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time;

import cz.auderis.tools.time.TimeProvider;
import cz.auderis.tools.time.TimeProviders;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ManualTimeProvider
implements TimeProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final AtomicLong time;

    public ManualTimeProvider() {
        this(TimeProviders.systemClock().getTimeInMillis());
    }

    public ManualTimeProvider(long startTime) {
        this.time = new AtomicLong(startTime);
    }

    @Override
    public long getTimeInMillis() {
        return this.time.get();
    }

    public ManualTimeProvider setTimeInMillis(long millis) {
        this.time.set(millis);
        return this;
    }

    public ManualTimeProvider step(long incrementMillis) {
        this.time.addAndGet(incrementMillis);
        return this;
    }

    public ManualTimeProvider step(long increment, TimeUnit unit) {
        if (null == unit) {
            throw new NullPointerException();
        }
        this.time.addAndGet(unit.toMillis(increment));
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("TimeProvider[");
        str.append("t=").append(this.time.get());
        str.append(", mode=manual]");
        return str.toString();
    }
}

