/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time;

import cz.auderis.tools.time.DurationFormatResource;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;

public abstract class SimpleDurationFormat
implements Serializable {
    static final TimeUnit[] DURATION_UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS};
    protected static final Map<TimeUnit, String> LABEL_BY_UNIT = new EnumMap<TimeUnit, String>(TimeUnit.class);
    private static final int CACHE_CAPACITY = 4;
    private static final Map<Locale, SimpleDurationFormat> FORMAT_CACHE;

    public static SimpleDurationFormat getInstance() {
        return SimpleDurationFormat.getInstance(Locale.getDefault());
    }

    public static SimpleDurationFormat getLanguageNeutralInstance() {
        return SimpleDurationFormat.getInstance(Locale.forLanguageTag("und"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDurationFormat getInstance(Locale locale) {
        SimpleDurationFormat result;
        if (null == locale) {
            throw new NullPointerException();
        }
        Map<Locale, SimpleDurationFormat> map = FORMAT_CACHE;
        synchronized (map) {
            result = FORMAT_CACHE.get(locale);
            if (null == result && (locale.equals(Locale.getDefault()) || FORMAT_CACHE.size() < 4)) {
                result = new LocalizedDurationFormat(locale);
                FORMAT_CACHE.put(locale, result);
            }
        }
        if (null == result) {
            result = new LocalizedDurationFormat(locale);
        }
        return result;
    }

    public abstract Appendable toHumanDuration(long var1, Appendable var3) throws IOException;

    public abstract Appendable toHumanDurationSafe(long var1, Appendable var3);

    public final String toHumanDuration(long millis) {
        StringBuilder builder = new StringBuilder();
        try {
            this.toHumanDuration(millis, builder);
        }
        catch (IOException e) {
            builder.setLength(0);
        }
        return builder.toString();
    }

    public final Appendable toHumanDuration(long duration, TimeUnit unit, Appendable target) throws IOException {
        if (null == unit) {
            throw new NullPointerException();
        }
        return this.toHumanDuration(unit.toMillis(duration), target);
    }

    public final Appendable toHumanDurationSafe(long duration, TimeUnit unit, Appendable target) {
        if (null == unit) {
            throw new NullPointerException();
        }
        return this.toHumanDurationSafe(unit.toMillis(duration), target);
    }

    public final String toHumanDuration(long duration, TimeUnit unit) {
        if (null == unit) {
            throw new NullPointerException();
        }
        return this.toHumanDuration(unit.toMillis(duration));
    }

    protected SimpleDurationFormat() {
    }

    static {
        LABEL_BY_UNIT.put(TimeUnit.DAYS, "days");
        LABEL_BY_UNIT.put(TimeUnit.HOURS, "hours");
        LABEL_BY_UNIT.put(TimeUnit.MINUTES, "minutes");
        LABEL_BY_UNIT.put(TimeUnit.SECONDS, "seconds");
        LABEL_BY_UNIT.put(TimeUnit.MILLISECONDS, "milliseconds");
        FORMAT_CACHE = new HashMap<Locale, SimpleDurationFormat>();
    }

    static class LocalizedDurationFormat
    extends SimpleDurationFormat {
        private static final long serialVersionUID = 1L;
        private static final String SPACE = " ";
        private final Map<TimeUnit, String> templateByUnit = new EnumMap<TimeUnit, String>(TimeUnit.class);
        private String separator;
        private String zeroTime;
        private TimeUnit leastDefinedUnit;

        protected LocalizedDurationFormat(Locale locale) {
            this.loadResources(locale);
        }

        @Override
        public Appendable toHumanDuration(long millis, Appendable target) throws IOException {
            if (null == target) {
                throw new NullPointerException();
            }
            if (millis < 0L) {
                throw new IllegalArgumentException("invalid duration");
            }
            if (0L == millis) {
                target.append(this.zeroTime);
                return target;
            }
            long remainingMillis = millis;
            String partSeparator = null;
            for (TimeUnit durationUnit : DURATION_UNITS) {
                String template = this.templateByUnit.get((Object)durationUnit);
                if (null == template) continue;
                long duration = durationUnit.convert(remainingMillis, TimeUnit.MILLISECONDS);
                if (null == partSeparator && duration < 2L && durationUnit != this.leastDefinedUnit) continue;
                if (null != partSeparator) {
                    target.append(partSeparator);
                } else {
                    partSeparator = this.separator;
                }
                String unitPart = MessageFormat.format(template, duration);
                target.append(unitPart);
                if (0L == (remainingMillis -= durationUnit.toMillis(duration)) || durationUnit == this.leastDefinedUnit) break;
            }
            return target;
        }

        @Override
        public Appendable toHumanDurationSafe(long millis, Appendable target) {
            if (null == target) {
                throw new NullPointerException();
            }
            if (millis < 0L) {
                throw new IllegalArgumentException("invalid duration");
            }
            try {
                return this.toHumanDuration(millis, target);
            }
            catch (IOException e) {
                return null;
            }
        }

        private void loadResources(Locale locale) {
            ResourceBundle res = this.findBundle(locale);
            this.separator = LocalizedDurationFormat.getResourceString(res, "PART_SEPARATOR", SPACE);
            this.zeroTime = LocalizedDurationFormat.getResourceString(res, "0 seconds", "0 seconds");
            this.leastDefinedUnit = null;
            for (TimeUnit timeUnit : DURATION_UNITS) {
                boolean isLastUnit;
                String resourceKey = (String)LABEL_BY_UNIT.get((Object)timeUnit);
                String template = LocalizedDurationFormat.getResourceString(res, resourceKey, null);
                if (null == template) {
                    template = "{0} " + resourceKey;
                }
                boolean unitIsUsed = !template.trim().isEmpty();
                boolean bl = isLastUnit = timeUnit == DURATION_UNITS[DURATION_UNITS.length - 1];
                if (unitIsUsed) {
                    this.templateByUnit.put(timeUnit, template);
                    this.leastDefinedUnit = timeUnit;
                    continue;
                }
                if (null != this.leastDefinedUnit || !isLastUnit) continue;
                this.templateByUnit.put(timeUnit, "{0} " + resourceKey);
                this.leastDefinedUnit = timeUnit;
            }
        }

        private ResourceBundle findBundle(Locale locale) {
            String simpleBundleName = DurationFormatResource.class.getSimpleName();
            try {
                return ResourceBundle.getBundle(simpleBundleName, locale);
            }
            catch (MissingResourceException e) {
                ClassLoader localClassloader = this.getClass().getClassLoader();
                try {
                    return ResourceBundle.getBundle(simpleBundleName, locale, localClassloader);
                }
                catch (MissingResourceException e2) {
                    String qualifiedBundleName = DurationFormatResource.class.getName();
                    try {
                        return ResourceBundle.getBundle(qualifiedBundleName, locale);
                    }
                    catch (MissingResourceException e3) {
                        try {
                            return ResourceBundle.getBundle(qualifiedBundleName, locale, localClassloader);
                        }
                        catch (MissingResourceException e4) {
                            return new DurationFormatResource();
                        }
                    }
                }
            }
        }

        private static String getResourceString(ResourceBundle resources, String key, String defaultValue) {
            String result = resources.containsKey(key) ? resources.getString(key) : defaultValue;
            return result;
        }
    }
}

