/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ThreadLocalDateFormat
extends DateFormat {
    private static final long serialVersionUID = -3298852618176961941L;
    public static final String ISO_FORMAT_MASK = "yyyy-MM-dd HH:mm:ss";
    private final String template;
    private final Locale locale;
    private transient ThreadLocal<SimpleDateFormat> format;

    public ThreadLocalDateFormat() {
        this(ISO_FORMAT_MASK);
    }

    public ThreadLocalDateFormat(String template) {
        this(template, null);
    }

    public ThreadLocalDateFormat(String template, Locale locale) {
        if (null == template) {
            throw new NullPointerException();
        }
        this.template = template;
        this.locale = locale;
        this.initFormatStore();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format.get().format(date, toAppendTo, pos);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return this.format.get().parse(source, pos);
    }

    @Override
    public ThreadLocalDateFormat clone() {
        ThreadLocalDateFormat clone = (ThreadLocalDateFormat)super.clone();
        clone.initFormatStore();
        return clone;
    }

    private void initFormatStore() {
        final Locale usedLocale = null != this.locale ? this.locale : Locale.getDefault();
        this.format = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(ThreadLocalDateFormat.this.template, usedLocale);
            }
        };
    }
}

