/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time;

import cz.auderis.tools.time.ManualTimeProvider;
import cz.auderis.tools.time.TimeProvider;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class TimeProviders {
    public static TimeProvider systemClock() {
        return ProviderImpl.SYSTEM;
    }

    public static ManualTimeProvider manual() {
        return new ManualTimeProvider(TimeProviders.systemClock().getTimeInMillis());
    }

    public static ManualTimeProvider manual(Date startTime) {
        if (null == startTime) {
            throw new NullPointerException();
        }
        return new ManualTimeProvider(startTime.getTime());
    }

    private TimeProviders() {
        throw new AssertionError();
    }

    static enum ProviderImpl implements TimeProvider
    {
        SYSTEM{

            @Override
            public long getTimeInMillis() {
                return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            }
        };

    }
}

