/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time.timeout;

import cz.auderis.tools.time.timeout.BeanBasedTimeout;
import cz.auderis.tools.time.timeout.CountingTimeout;
import cz.auderis.tools.time.timeout.Timeout;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

class CountingTimeoutImpl
implements CountingTimeout,
Serializable {
    private static final long serialVersionUID = 5698692496260987879L;
    private final Timeout baseTimeout;
    private AtomicInteger expirationCount;
    private int expirationIncrement;

    public CountingTimeoutImpl(Timeout timeout) {
        if (null == timeout) {
            throw new NullPointerException();
        }
        if (timeout.isRunning()) {
            throw new IllegalArgumentException("timeout is already running");
        }
        this.baseTimeout = timeout;
        this.expirationCount = new AtomicInteger();
        this.expirationIncrement = 0;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (this.baseTimeout instanceof BeanBasedTimeout) {
            ((BeanBasedTimeout)this.baseTimeout).addPropertyChangeListener(lsnr);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (this.baseTimeout instanceof BeanBasedTimeout) {
            ((BeanBasedTimeout)this.baseTimeout).addPropertyChangeListener(propertyName, lsnr);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (this.baseTimeout instanceof BeanBasedTimeout) {
            ((BeanBasedTimeout)this.baseTimeout).removePropertyChangeListener(lsnr);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (this.baseTimeout instanceof BeanBasedTimeout) {
            ((BeanBasedTimeout)this.baseTimeout).removePropertyChangeListener(propertyName, lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountingTimeoutImpl start() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            this.baseTimeout.start();
            this.expirationIncrement = 1;
            this.expirationCount.set(0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountingTimeoutImpl startIfNotRunning() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            if (!this.baseTimeout.isRunning()) {
                this.baseTimeout.start();
                this.expirationIncrement = 1;
                this.expirationCount.set(0);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountingTimeoutImpl stop() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            this.isElapsed();
            this.expirationIncrement = 0;
            this.baseTimeout.stop();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountingTimeoutImpl restart() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            this.baseTimeout.restart();
            this.expirationIncrement = 1;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartIfElapsed() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            boolean result = true;
            if (!this.baseTimeout.isRunning()) {
                this.baseTimeout.start();
                this.expirationIncrement = 1;
                this.expirationCount.set(0);
            } else if (this.baseTimeout.restartIfElapsed()) {
                this.expirationCount.addAndGet(this.expirationIncrement);
                this.expirationIncrement = 1;
            } else {
                result = false;
            }
            return result;
        }
    }

    @Override
    public void expireNow() {
        this.baseTimeout.expireNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isElapsed() {
        boolean elapsed = this.baseTimeout.isElapsed();
        if (elapsed) {
            Timeout timeout = this.baseTimeout;
            synchronized (timeout) {
                this.expirationCount.addAndGet(this.expirationIncrement);
                this.expirationIncrement = 0;
            }
        }
        return elapsed;
    }

    @Override
    public boolean isExpired() {
        return this.isRunning() ? this.isElapsed() : false;
    }

    @Override
    public long getTimeout() {
        return this.baseTimeout.getTimeout();
    }

    @Override
    public CountingTimeoutImpl setTimeout(long millis) {
        this.baseTimeout.setTimeout(millis);
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.baseTimeout.isRunning();
    }

    @Override
    public int getRemainingPercent() {
        return this.baseTimeout.getRemainingPercent();
    }

    @Override
    public Long getRemainingMillis() {
        return this.baseTimeout.getRemainingMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFirstRun() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            return 0 == this.expirationCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getExpirationCount() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            this.isElapsed();
            return this.expirationCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountingTimeoutImpl resetExpirationCount() {
        Timeout timeout = this.baseTimeout;
        synchronized (timeout) {
            this.expirationIncrement = 1;
            this.expirationCount.set(0);
        }
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("CountingTimeout[");
        str.append(this.baseTimeout);
        str.append(", count=").append(this.expirationCount.get());
        str.append("]");
        return str.toString();
    }
}

