/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time.timeout;

import cz.auderis.tools.time.timeout.AbstractBeanBasedTimeout;
import cz.auderis.tools.time.timeout.CountingTimeoutImpl;
import cz.auderis.tools.time.timeout.Timeout;
import cz.auderis.tools.time.timeout.Timeouts;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SwitchingTimeout
extends AbstractBeanBasedTimeout {
    private static final long serialVersionUID = 2751030086140217459L;
    private final List<TimeoutRecord> timeouts = new ArrayList<TimeoutRecord>();
    private final TimeoutRecord finalTimeout = new TimeoutRecord(Timeouts.infinite(), 1, false);
    private int currentIndex = -1;

    public SwitchingTimeout append(Timeout timeout, int repeatCount, boolean removeAfterLastCycle) {
        if (null == timeout) {
            throw new NullPointerException();
        }
        if (timeout.isRunning()) {
            throw new IllegalArgumentException("provided timeout is running");
        }
        if (repeatCount < 1) {
            throw new IllegalArgumentException("repeat count must be positive");
        }
        if (this.isRunning()) {
            throw new IllegalStateException("timeout is already running");
        }
        TimeoutRecord record = new TimeoutRecord(timeout, repeatCount, removeAfterLastCycle);
        this.timeouts.add(record);
        return this;
    }

    @Override
    public long getTimeout() {
        TimeoutRecord record = this.getCurrentRecord();
        return record.getInstance().getTimeout();
    }

    @Override
    public SwitchingTimeout setTimeout(long millis) {
        throw new UnsupportedOperationException("cannot change switching timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SwitchingTimeout start() {
        if (this.isRunning()) {
            throw new IllegalStateException("timeout is already running");
        }
        List<TimeoutRecord> list = this.timeouts;
        synchronized (list) {
            this.currentIndex = 0;
            TimeoutRecord record = this.getCurrentRecord();
            record.getInstance().start().resetExpirationCount();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SwitchingTimeout startIfNotRunning() {
        if (this.timeouts.isEmpty()) {
            this.finalTimeout.getInstance().startIfNotRunning();
            return this;
        }
        List<TimeoutRecord> list = this.timeouts;
        synchronized (list) {
            if (!this.isRunning()) {
                if (this.currentIndex < 0) {
                    this.currentIndex = 0;
                    TimeoutRecord record = this.getCurrentRecord();
                    record.getInstance().restart();
                } else {
                    TimeoutRecord record = this.timeouts.get(this.currentIndex);
                    if (record.isSwitchNeeded()) {
                        if (record.isRemovableAfterFullCycle()) {
                            this.timeouts.remove(this.currentIndex);
                        } else {
                            record.getInstance().stop();
                            ++this.currentIndex;
                        }
                        this.fixCurrentIndex();
                        record = this.getCurrentRecord();
                        record.getInstance().resetExpirationCount();
                    }
                    record.getInstance().restart();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SwitchingTimeout stop() {
        if (this.timeouts.isEmpty()) {
            return this;
        }
        List<TimeoutRecord> list = this.timeouts;
        synchronized (list) {
            if (this.isRunning()) {
                TimeoutRecord record = this.getCurrentRecord();
                record.getInstance().stop();
            }
        }
        return this;
    }

    private void fixCurrentIndex() {
        int size = this.timeouts.size();
        if (0 == size) {
            this.currentIndex = -1;
        } else if (this.currentIndex >= size) {
            this.currentIndex %= size;
        }
    }

    private TimeoutRecord getCurrentRecord() {
        if (this.timeouts.isEmpty()) {
            return this.finalTimeout;
        }
        if (this.currentIndex < 0) {
            return this.timeouts.get(0);
        }
        return this.timeouts.get(this.currentIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SwitchingTimeout restart() {
        if (this.timeouts.isEmpty()) {
            this.finalTimeout.getInstance().restart();
            return this;
        }
        List<TimeoutRecord> list = this.timeouts;
        synchronized (list) {
            if (this.currentIndex < 0) {
                this.currentIndex = 0;
                TimeoutRecord record = this.timeouts.get(this.currentIndex);
                record.getInstance().startIfNotRunning();
            } else {
                TimeoutRecord record = this.timeouts.get(this.currentIndex);
                if (record.isSwitchNeeded()) {
                    record.getInstance().stop();
                    if (record.isRemovableAfterFullCycle()) {
                        this.timeouts.remove(this.currentIndex);
                    } else {
                        ++this.currentIndex;
                    }
                    this.fixCurrentIndex();
                    record = this.getCurrentRecord();
                    record.getInstance().resetExpirationCount();
                }
                record.getInstance().restart();
            }
        }
        return this;
    }

    @Override
    public boolean restartIfElapsed() {
        boolean result = false;
        if (this.timeouts.isEmpty()) {
            result = this.finalTimeout.getInstance().restartIfElapsed();
        } else if (!this.isRunning() || this.isElapsed()) {
            this.restart();
            result = true;
        }
        return result;
    }

    @Override
    public void expireNow() {
        if (this.isRunning()) {
            this.getCurrentRecord().getInstance().expireNow();
        }
    }

    @Override
    public boolean isRunning() {
        return this.getCurrentRecord().getInstance().isRunning();
    }

    @Override
    public boolean isElapsed() {
        return this.getCurrentRecord().getInstance().isElapsed();
    }

    @Override
    public boolean isExpired() {
        return this.getCurrentRecord().getInstance().isExpired();
    }

    @Override
    public int getRemainingPercent() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.getCurrentRecord().getInstance().getRemainingPercent();
    }

    @Override
    public Long getRemainingMillis() {
        if (!this.isRunning()) {
            return -1L;
        }
        return this.getCurrentRecord().getInstance().getRemainingMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("SwitchingTimeout[");
        String separator = null;
        for (int i = 0; i < this.timeouts.size(); ++i) {
            if (null == separator) {
                separator = ", ";
            } else {
                str.append(separator);
            }
            if (this.currentIndex == i) {
                str.append('*');
            }
            TimeoutRecord record = this.timeouts.get(i);
            str.append(record.getInstance());
            str.append(" x").append(record.getMaxRepeatCount());
        }
        str.append("]");
        return str.toString();
    }

    final class PropertyChangeForwarder
    implements PropertyChangeListener {
        PropertyChangeForwarder() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getOldValue();
            PropertyChangeEvent forwardedEvent = new PropertyChangeEvent(SwitchingTimeout.this, propertyName, oldValue, newValue);
            forwardedEvent.setPropagationId(evt.getPropagationId());
            SwitchingTimeout.this.firePropertyChange(forwardedEvent);
        }
    }

    static class TimeoutRecord
    implements Serializable {
        private static final long serialVersionUID = -8941865969050966469L;
        private final Timeout timeout;
        private final CountingTimeoutImpl countingDecorator;
        private int repeatCount;
        private boolean removeAfterLastExpiration;

        public TimeoutRecord(Timeout timeout, int repeats, boolean removable) {
            this.timeout = timeout;
            this.countingDecorator = new CountingTimeoutImpl(timeout);
            this.repeatCount = repeats;
            this.removeAfterLastExpiration = removable;
        }

        public CountingTimeoutImpl getInstance() {
            return this.countingDecorator;
        }

        public Timeout getOriginalInstance() {
            return this.timeout;
        }

        public int getMaxRepeatCount() {
            return this.repeatCount;
        }

        public boolean isRemovableAfterFullCycle() {
            return this.removeAfterLastExpiration;
        }

        public boolean isSwitchNeeded() {
            if (!this.countingDecorator.isRunning()) {
                return false;
            }
            int currentCount = this.countingDecorator.getExpirationCount();
            return currentCount >= this.repeatCount;
        }
    }
}

