/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time.timeout;

import cz.auderis.tools.time.timeout.BeanBasedTimeout;
import cz.auderis.tools.time.timeout.Timeout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimeoutPropertyDecorator
implements BeanBasedTimeout,
Serializable {
    private static final long serialVersionUID = -3295590130661117566L;
    protected final Timeout delegate;
    protected PropertyChangeSupport propertyChangeSupport;
    protected AtomicBoolean lastExpirationState;

    public TimeoutPropertyDecorator(Timeout delegate) {
        if (null == delegate) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.lastExpirationState = new AtomicBoolean(delegate.isElapsed());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (null == this.propertyChangeSupport) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(lsnr);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
        if (null == lsnr) {
            throw new NullPointerException();
        }
        if (null == this.propertyChangeSupport) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, lsnr);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener lsnr) {
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.removePropertyChangeListener(lsnr);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener lsnr) {
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, lsnr);
        }
    }

    @Override
    public long getTimeout() {
        long result = this.delegate.getTimeout();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public Timeout setTimeout(long millis) {
        long origTimeout = this.delegate.getTimeout();
        this.delegate.setTimeout(millis);
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("timeout", origTimeout, millis);
        }
        this.checkExpirationChange();
        return this;
    }

    @Override
    public Timeout start() {
        boolean origRunning = this.delegate.isRunning();
        this.delegate.start();
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("running", origRunning, true);
        }
        this.checkExpirationChange();
        return this;
    }

    @Override
    public Timeout startIfNotRunning() {
        boolean origRunning = this.delegate.isRunning();
        this.delegate.startIfNotRunning();
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("running", origRunning, true);
        }
        this.checkExpirationChange();
        return this;
    }

    @Override
    public Timeout stop() {
        boolean origRunning = this.delegate.isRunning();
        this.delegate.stop();
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("running", origRunning, false);
        }
        this.checkExpirationChange();
        return this;
    }

    @Override
    public Timeout restart() {
        boolean origRunning = this.delegate.isRunning();
        this.delegate.restart();
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("running", origRunning, true);
        }
        this.checkExpirationChange();
        return this;
    }

    @Override
    public boolean isRunning() {
        boolean result = this.delegate.isRunning();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public boolean isElapsed() {
        boolean result = this.delegate.isElapsed();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public boolean restartIfElapsed() {
        boolean origRunning = this.delegate.isRunning();
        boolean restarted = this.delegate.restartIfElapsed();
        if (null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("running", origRunning, this.delegate.isRunning());
        }
        this.checkExpirationChange();
        return restarted;
    }

    @Override
    public int getRemainingPercent() {
        int result = this.delegate.getRemainingPercent();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public Long getRemainingMillis() {
        Long result = this.delegate.getRemainingMillis();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public boolean isExpired() {
        boolean result = this.delegate.isExpired();
        this.checkExpirationChange();
        return result;
    }

    @Override
    public void expireNow() {
        this.delegate.expireNow();
        this.checkExpirationChange();
    }

    public void checkExpirationChange() {
        boolean currentState = this.delegate.isElapsed();
        boolean changeOccurred = this.lastExpirationState.compareAndSet(!currentState, currentState);
        if (changeOccurred && null != this.propertyChangeSupport) {
            this.propertyChangeSupport.firePropertyChange("elapsed", !currentState, currentState);
        }
    }
}

