/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time.timeout;

import cz.auderis.tools.time.TimeProvider;
import cz.auderis.tools.time.timeout.AbstractBeanBasedTimeout;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class TimeoutWithProviderImpl
extends AbstractBeanBasedTimeout
implements Serializable {
    private static final long serialVersionUID = 7678557975218056071L;
    private static final String ERR_TIMEOUT_NEGATIVE = "timeout must not be negative";
    private static final String ERR_TIMEOUT_NOT_RUNNING = "timeout not running";
    private static final long PREC_SCALE = 1024L;
    private static final AtomicInteger TIMEOUT_ID_SEQUENCE = new AtomicInteger(1);
    private final int id;
    private final TimeProvider clock;
    private final ReadWriteLock mutex;
    private volatile boolean running;
    private volatile long timeout;
    private volatile long startTime;

    TimeoutWithProviderImpl(long millis, TimeProvider clock) {
        if (millis < 0L) {
            throw new IllegalArgumentException(ERR_TIMEOUT_NEGATIVE);
        }
        if (null == clock) {
            throw new NullPointerException();
        }
        this.id = TIMEOUT_ID_SEQUENCE.getAndIncrement();
        this.clock = clock;
        this.mutex = new ReentrantReadWriteLock();
        this.timeout = millis;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeoutWithProviderImpl setTimeout(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException(ERR_TIMEOUT_NEGATIVE);
        }
        if (this.running) {
            throw new IllegalStateException("cannot change running timeout");
        }
        this.mutex.writeLock().lock();
        long oldMillis = this.timeout;
        try {
            this.timeout = millis;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("timeout", oldMillis, millis);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeout(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException(ERR_TIMEOUT_NEGATIVE);
        }
        this.mutex.writeLock().lock();
        long oldMillis = this.timeout;
        try {
            this.timeout = millis;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("timeout", oldMillis, millis);
    }

    @Override
    public TimeoutWithProviderImpl start() {
        long currentTime = this.clock.getTimeInMillis();
        if (this.running) {
            throw new IllegalStateException("timeout is already running");
        }
        this.mutex.writeLock().lock();
        try {
            if (!this.running) {
                this.running = true;
                this.startTime = currentTime;
            }
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("running", false, true);
        return this;
    }

    @Override
    public TimeoutWithProviderImpl startIfNotRunning() {
        long currentTime = this.clock.getTimeInMillis();
        if (this.running) {
            return this;
        }
        this.mutex.writeLock().lock();
        try {
            if (!this.running) {
                this.running = true;
                this.startTime = currentTime;
            }
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("running", false, true);
        return this;
    }

    @Override
    public TimeoutWithProviderImpl stop() {
        if (this.running) {
            this.mutex.writeLock().lock();
            try {
                this.running = false;
            }
            finally {
                this.mutex.writeLock().unlock();
            }
            this.firePropertyChange("running", true, false);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeoutWithProviderImpl restart() {
        long currentTime = this.clock.getTimeInMillis();
        this.mutex.writeLock().lock();
        boolean oldRunning = this.running;
        try {
            this.running = true;
            this.startTime = currentTime;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("running", oldRunning, true);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartIfElapsed() {
        long currentTime = this.clock.getTimeInMillis();
        long expirationTime = this.startTime + this.timeout;
        if (this.running && currentTime < expirationTime) {
            return false;
        }
        this.mutex.writeLock().lock();
        boolean oldRunning = this.running;
        boolean restarted = false;
        try {
            currentTime = this.clock.getTimeInMillis();
            expirationTime = this.startTime + this.timeout;
            if (!this.running || currentTime >= expirationTime) {
                this.running = true;
                this.startTime = currentTime;
                restarted = true;
            }
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        this.firePropertyChange("running", oldRunning, true);
        return restarted;
    }

    @Override
    public void expireNow() {
        block4: {
            long currentTime = this.clock.getTimeInMillis();
            this.mutex.writeLock().lock();
            try {
                if (this.running) {
                    this.startTime = currentTime - this.timeout;
                    break block4;
                }
                throw new IllegalStateException(ERR_TIMEOUT_NOT_RUNNING);
            }
            finally {
                this.mutex.writeLock().unlock();
            }
        }
        this.firePropertyChange("elapsed", false, true);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isElapsed() {
        if (!this.running) {
            return false;
        }
        boolean mutexAcquired = this.mutex.readLock().tryLock();
        try {
            long currentTime = this.clock.getTimeInMillis();
            boolean bl = currentTime >= this.startTime + this.timeout;
            return bl;
        }
        finally {
            if (mutexAcquired) {
                this.mutex.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingPercent() {
        long tmout;
        long diff;
        if (!this.running) {
            throw new IllegalStateException(ERR_TIMEOUT_NOT_RUNNING);
        }
        long currentTime = this.clock.getTimeInMillis();
        boolean mutexAcquired = this.mutex.readLock().tryLock();
        try {
            if (!this.running) {
                throw new IllegalStateException(ERR_TIMEOUT_NOT_RUNNING);
            }
            diff = this.startTime + this.timeout - currentTime;
            tmout = this.timeout;
        }
        finally {
            if (mutexAcquired) {
                this.mutex.readLock().unlock();
            }
        }
        if (diff >= tmout) {
            return 100;
        }
        if (diff <= 0L) {
            return 0;
        }
        long percent = (102400L * diff / tmout + 512L) / 1024L;
        return (int)percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRemainingMillis() {
        long currentTime = this.clock.getTimeInMillis();
        if (!this.running) {
            return null;
        }
        boolean mutexAcquired = this.mutex.readLock().tryLock();
        try {
            if (!this.running) {
                Long l = null;
                return l;
            }
            long remaining = this.startTime + this.timeout - currentTime;
            Long l = remaining > 0L ? remaining : 0L;
            return l;
        }
        finally {
            if (mutexAcquired) {
                this.mutex.readLock().unlock();
            }
        }
    }

    @Override
    public boolean isExpired() {
        return this.isRunning() ? this.isElapsed() : false;
    }

    public int hashCode() {
        return 0x65 ^ Objects.hash(this.clock) ^ this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !(obj instanceof TimeoutWithProviderImpl)) {
            return false;
        }
        TimeoutWithProviderImpl other = (TimeoutWithProviderImpl)obj;
        if (!Objects.equals(this.clock, other.clock)) {
            return false;
        }
        if (this.running != other.running) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Timeout[");
        this.mutex.readLock().lock();
        this.mutex.readLock().unlock();
        str.append("]");
        return str.toString();
    }
}

