/*
 * Decompiled with CFR 0.152.
 */
package cz.auderis.tools.time.timeout;

import cz.auderis.tools.time.TimeProvider;
import cz.auderis.tools.time.TimeProviders;
import cz.auderis.tools.time.timeout.AlwaysExpiredTimeoutImpl;
import cz.auderis.tools.time.timeout.CountingTimeout;
import cz.auderis.tools.time.timeout.CountingTimeoutImpl;
import cz.auderis.tools.time.timeout.InfiniteTimeoutImpl;
import cz.auderis.tools.time.timeout.Timeout;
import cz.auderis.tools.time.timeout.TimeoutWithProviderImpl;
import java.util.concurrent.TimeUnit;

public final class Timeouts {
    private static final String INVALID_TIMEOUT = "invalid timeout duration";

    public static Timeout simple(long duration, TimeUnit durationUnit) {
        if (null == durationUnit) {
            throw new NullPointerException();
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException(INVALID_TIMEOUT);
        }
        long millis = durationUnit.toMillis(duration);
        TimeoutWithProviderImpl t = new TimeoutWithProviderImpl(millis, TimeProviders.systemClock());
        return t;
    }

    public static Timeout simpleWithProvider(long duration, TimeUnit durationUnit, TimeProvider provider) {
        if (null == durationUnit) {
            throw new NullPointerException();
        }
        if (null == provider) {
            throw new NullPointerException();
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException(INVALID_TIMEOUT);
        }
        long millis = durationUnit.toMillis(duration);
        TimeoutWithProviderImpl t = new TimeoutWithProviderImpl(millis, provider);
        return t;
    }

    public static CountingTimeout counting(long duration, TimeUnit durationUnit) {
        if (null == durationUnit) {
            throw new NullPointerException();
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException(INVALID_TIMEOUT);
        }
        long millis = durationUnit.toMillis(duration);
        TimeoutWithProviderImpl t1 = new TimeoutWithProviderImpl(millis, TimeProviders.systemClock());
        CountingTimeoutImpl t2 = new CountingTimeoutImpl(t1);
        return t2;
    }

    public static CountingTimeout counting(Timeout decoratedTimeout) {
        if (null == decoratedTimeout) {
            throw new NullPointerException();
        }
        CountingTimeoutImpl t = new CountingTimeoutImpl(decoratedTimeout);
        return t;
    }

    public static Timeout infinite() {
        InfiniteTimeoutImpl t = new InfiniteTimeoutImpl();
        return t;
    }

    public static Timeout alwaysExpired() {
        return AlwaysExpiredTimeoutImpl.getInstance();
    }

    private Timeouts() {
        throw new AssertionError();
    }
}

