/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.internal;

import cz.cdv.datex2.Datex2Client;
import cz.cdv.datex2.Datex2Subscription;
import cz.cdv.datex2.handlers.Datex2Handler;
import cz.cdv.datex2.internal.Register;
import cz.cdv.datex2.wsdl.clientsubscribe.ClientSubscribeInterface;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.wsdl.clientpull._2_0.ClientPullInterface;
import java.util.List;

public class Datex2ClientImpl
implements Datex2Client {
    private ClientPullInterface pullEndPoint;
    private ClientSubscribeInterface subscriptionEndPoint;
    private Register<Datex2Handler> handlers = new Register();

    public Datex2ClientImpl(ClientPullInterface pullEndPoint, ClientSubscribeInterface subscriptionEndPoint) {
        this.pullEndPoint = pullEndPoint;
        this.subscriptionEndPoint = subscriptionEndPoint;
    }

    @Override
    public void pull() {
        this.handle(this.get());
    }

    @Override
    public String subscribe(Datex2Subscription subscription) {
        if (this.subscriptionEndPoint == null) {
            throw new UnsupportedOperationException("Client is not initialized with subscription endpoint URL");
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Subscription must be specified");
        }
        return this.subscriptionEndPoint.subscribe(subscription.getModel());
    }

    @Override
    public D2LogicalModel get() {
        return this.pullEndPoint.getDatex2Data();
    }

    public void push(D2LogicalModel model) {
        this.handle(model);
    }

    private void handle(D2LogicalModel model) {
        for (Datex2Handler handler : this.getHandlers()) {
            handler.handle(model);
        }
    }

    @Override
    public void addHandler(Datex2Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void removeHandler(Datex2Handler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public List<Datex2Handler> getHandlers() {
        return this.handlers.getAll();
    }
}

