/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.internal;

import cz.cdv.datex2.Datex2Supplier;
import cz.cdv.datex2.internal.Register;
import cz.cdv.datex2.internal.Subscriptions;
import cz.cdv.datex2.providers.ChangesProvider;
import cz.cdv.datex2.providers.Datex2Provider;
import cz.cdv.datex2.providers.SnapshotProvider;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.UpdateMethodEnum;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class Datex2SupplierImpl
implements Datex2Supplier,
InitializingBean {
    @Autowired
    private Subscriptions subscriptions;
    private String supplierPath;
    private Register<Datex2Provider> providers = new Register();
    private ProviderAdaptor<SnapshotProvider> snapshotProviderAdaptor = new ProviderAdaptor<SnapshotProvider>(){

        @Override
        public D2LogicalModel get(SnapshotProvider provider) {
            if (provider == null) {
                return null;
            }
            return provider.getSnapshot();
        }
    };

    public Datex2SupplierImpl(String supplierPath, String subscriptionPath) {
        this.supplierPath = supplierPath;
    }

    public void afterPropertiesSet() throws Exception {
        this.subscriptions.registerSupplier(this.supplierPath, this);
    }

    @Override
    public void push(String ... changes) {
        this.subscriptions.push(this.supplierPath, changes);
    }

    @Override
    public D2LogicalModel getSnapshot() {
        return this.getD2LogicalModel(SnapshotProvider.class, this.snapshotProviderAdaptor);
    }

    @Override
    public D2LogicalModel getChanges(final UpdateMethodEnum updateMethod, final String ... changes) {
        return this.getD2LogicalModel(ChangesProvider.class, new ProviderAdaptor<ChangesProvider>(){

            @Override
            public D2LogicalModel get(ChangesProvider provider) {
                if (provider == null) {
                    return null;
                }
                return provider.getChanges(updateMethod, changes);
            }
        });
    }

    private <P extends Datex2Provider> D2LogicalModel getD2LogicalModel(Class<P> providerClazz, ProviderAdaptor<P> adaptor) {
        for (Datex2Provider provider : this.getProviders(providerClazz)) {
            D2LogicalModel value = adaptor.get(provider);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void addProvider(Datex2Provider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeProvider(Datex2Provider provider) {
        this.providers.remove(provider);
    }

    @Override
    public List<Datex2Provider> getProviders() {
        return this.providers.getAll();
    }

    @Override
    public <S extends Datex2Provider> List<S> getProviders(Class<S> clazz) {
        return this.providers.getAll(clazz);
    }

    private static interface ProviderAdaptor<P extends Datex2Provider> {
        public D2LogicalModel get(P var1);
    }
}

