/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.internal;

import eu.datex2.schema._2._2_0.Target;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PushTarget
implements Serializable {
    private static Logger log = Logger.getLogger(PushTarget.class.getSimpleName());
    private final URL url;
    private final String username;
    private final String password;

    public static PushTarget create(Target target) {
        try {
            return new PushTarget(new URL(target.getAddress()), null, null);
        }
        catch (MalformedURLException e) {
            log.log(Level.SEVERE, "Error parsing target", e);
            return null;
        }
    }

    public PushTarget(URL url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        if (this.username == null && this.password == null) {
            return this.url.toString();
        }
        return (this.username != null ? this.username : "") + (this.password != null ? ":" + this.password : "") + " @ " + this.url.toString();
    }

    public Target toTarget() {
        Target t = new Target();
        t.setAddress(this.url.toString());
        t.setProtocol(this.url.getProtocol());
        return t;
    }
}

