/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.internal;

import cz.cdv.datex2.Datex2Subscription;
import cz.cdv.datex2.Datex2Supplier;
import cz.cdv.datex2.internal.BoundedPeriodicTrigger;
import cz.cdv.datex2.internal.PushTarget;
import cz.cdv.datex2.internal.Pusher;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.UpdateMethodEnum;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Fun;
import org.mapdb.HTreeMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class Subscriptions
implements InitializingBean,
DisposableBean {
    private static Logger log = Logger.getLogger(Subscriptions.class.getSimpleName());
    @Autowired
    private TaskScheduler scheduler;
    @Autowired
    private Pusher pusher;
    private DB db = null;
    private HTreeMap<String, Entry> entries;
    private NavigableSet<Fun.Tuple2<String, String>> supplierIndex;
    private HTreeMap<String, List<String>> changesHistory;
    private HTreeMap<String, String> lastChanges;
    private Map<String, ScheduledFuture<?>> scheduled = new ConcurrentHashMap();
    private Map<String, Datex2Supplier> suppliers = new ConcurrentHashMap<String, Datex2Supplier>();

    public void registerSupplier(String supplierPath, Datex2Supplier supplier) {
        this.suppliers.put(supplierPath, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String supplier, String ... changes) {
        try {
            this.addChanges(supplier, changes);
            for (String reference : this.getReferences(supplier)) {
                Entry entry = (Entry)this.entries.get((Object)reference);
                if (entry.getPeriodSeconds() != null) continue;
                this.execute(reference);
            }
        }
        finally {
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addPeriodic(String supplier, Calendar startTime, Calendar stopTime, Float periodSeconds, UpdateMethodEnum updateMethod, List<PushTarget> pushTargets) {
        try {
            String reference = this.createReference();
            Entry entry = this.createEntry(supplier, updateMethod, pushTargets, startTime, stopTime, periodSeconds);
            this.entries.put((Object)reference, (Object)entry);
            this.createLastChange(reference, entry);
            this.schedule(reference, startTime, stopTime, periodSeconds);
            String string = reference;
            return string;
        }
        finally {
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updatePeriodic(String supplier, String reference, Calendar startTime, Calendar stopTime, Float periodSeconds, UpdateMethodEnum updateMethod, List<PushTarget> pushTargets) {
        try {
            Entry entry = this.createEntry(supplier, updateMethod, pushTargets, startTime, stopTime, periodSeconds);
            this.entries.put((Object)reference, (Object)entry);
            this.schedule(reference, startTime, stopTime, periodSeconds);
            String string = reference;
            return string;
        }
        finally {
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(String supplier, UpdateMethodEnum updateMethod, Calendar startTime, Calendar stopTime, List<PushTarget> pushTargets) {
        try {
            String reference = this.createReference();
            Entry entry = this.createEntry(supplier, updateMethod, pushTargets, startTime, stopTime, null);
            this.entries.put((Object)reference, (Object)entry);
            this.createLastChange(reference, entry);
            String string = reference;
            return string;
        }
        finally {
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String update(String supplier, String reference, UpdateMethodEnum updateMethod, Calendar startTime, Calendar stopTime, List<PushTarget> pushTargets) {
        try {
            Entry entry = this.createEntry(supplier, updateMethod, pushTargets, startTime, stopTime, null);
            this.entries.put((Object)reference, (Object)entry);
            String string = reference;
            return string;
        }
        finally {
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String supplier, String reference) {
        try {
            Entry entry = (Entry)this.entries.get((Object)reference);
            if (entry != null) {
                if (supplier != null && entry.getSupplier() != null && supplier.equals(entry.getSupplier())) {
                    this.entries.remove((Object)reference);
                } else {
                    return;
                }
            }
            this.cancelSchedule(reference);
        }
        finally {
            this.db.commit();
        }
    }

    public void afterPropertiesSet() throws Exception {
        String dbFileName = System.getProperty("user.dir") + "/" + "subscriptions";
        File dbFile = new File(dbFileName);
        log.info("Subscriptions will be stored in: " + dbFile.getAbsolutePath());
        if (!dbFile.exists()) {
            dbFile.getParentFile().mkdirs();
        }
        this.db = DBMaker.newFileDB((File)dbFile).asyncWriteEnable().checksumEnable().mmapFileEnableIfSupported().cacheSize(50).cacheLRUEnable().transactionDisable().make();
        this.entries = this.db.createHashMap("Entry").makeOrGet();
        this.supplierIndex = new TreeSet<Fun.Tuple2<String, String>>();
        Bind.secondaryKey(this.entries, this.supplierIndex, (Fun.Function2)new Fun.Function2<String, String, Entry>(){

            public String run(String reference, Entry entry) {
                try {
                    if (entry == null) {
                        return null;
                    }
                    return entry.getSupplier();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.changesHistory = this.db.createHashMap("ChangesSet").makeOrGet();
        this.lastChanges = this.db.createHashMap("LastChanges").makeOrGet();
        for (String reference : this.entries.keySet()) {
            Entry entry = (Entry)this.entries.get((Object)reference);
            if (entry.getPeriodSeconds() == null) continue;
            this.schedule(reference, entry.getStartTime(), entry.getStopTime(), entry.getPeriodSeconds());
        }
        this.db.commit();
    }

    public void destroy() throws Exception {
        if (this.db == null) {
            return;
        }
        this.db.close();
        this.db = null;
    }

    private String createReference() {
        return UUID.randomUUID().toString();
    }

    private Entry createEntry(String supplier, UpdateMethodEnum updateMethod, List<PushTarget> pushTargets, Calendar startTime, Calendar stopTime, Float periodSeconds) {
        if (supplier == null) {
            throw new IllegalArgumentException("'supplier' is null");
        }
        return new Entry(supplier, updateMethod, pushTargets, startTime, stopTime, periodSeconds);
    }

    private Iterable<String> getReferences(String supplier) {
        return Fun.filter(this.supplierIndex, (Object)supplier);
    }

    private void schedule(String reference, Calendar startTime, Calendar stopTime, Float periodSeconds) {
        this.cancelSchedule(reference);
        ScheduledFuture schedule = this.scheduler.schedule(this.createTask(reference), this.createTrigger(startTime, stopTime, periodSeconds));
        this.scheduled.put(reference, schedule);
    }

    private void cancelSchedule(String reference) {
        ScheduledFuture<?> schedule = this.scheduled.get(reference);
        if (schedule != null) {
            schedule.cancel(false);
        }
    }

    private Trigger createTrigger(Calendar startTime, Calendar stopTime, Float periodSeconds) {
        long periodMillis = Math.round(periodSeconds.floatValue() * 1000.0f);
        return new BoundedPeriodicTrigger(startTime.getTime(), stopTime.getTime(), periodMillis);
    }

    private Runnable createTask(String reference) {
        return new Task(reference);
    }

    private void execute(String reference) {
        Entry entry = (Entry)this.entries.get((Object)reference);
        if (entry == null) {
            return;
        }
        boolean applicable = true;
        Calendar now = Calendar.getInstance();
        if (entry.getStartTime() != null && entry.getStartTime().after(now) || entry.getStopTime() != null && entry.getStopTime().before(now)) {
            applicable = false;
        }
        String supplierId = entry.getSupplier();
        Datex2Supplier supplier = this.suppliers.get(supplierId);
        UpdateMethodEnum updateMethod = entry.getUpdateMethod();
        for (PushTarget target : entry.getPushTargets()) {
            String[] changes;
            D2LogicalModel model = null;
            if (updateMethod == UpdateMethodEnum.SNAPSHOT) {
                model = supplier.getSnapshot();
                changes = null;
            } else {
                changes = this.getNewChanges(reference, target);
                if (changes == null || changes.length == 0) continue;
                if (applicable) {
                    model = supplier.getChanges(updateMethod, changes);
                }
            }
            if (applicable) {
                if (model == null) continue;
                Datex2Subscription d2s = Datex2Subscription.newBuilder().reference(reference).start(entry.getStartTime()).stop(entry.getStopTime()).periodic(entry.getPeriodSeconds()).update(entry.getUpdateMethod()).target(entry.getPushTargets()).build();
                d2s.updateModel(model);
            }
            try {
                if (applicable) {
                    this.supplierPush(model, target);
                }
                this.setPushedChanges(reference, target, changes);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't push to " + target, e);
            }
        }
    }

    private void supplierPush(D2LogicalModel model, PushTarget target) {
        this.pusher.push(target, model);
    }

    private void addChanges(String supplier, String ... changes) {
        if (changes == null || changes.length == 0) {
            return;
        }
        List<String> supplierHistory = (List<String>)this.changesHistory.get((Object)supplier);
        if (supplierHistory == null) {
            supplierHistory = Collections.synchronizedList(new ArrayList());
            this.changesHistory.put((Object)supplier, supplierHistory);
        }
        for (String change : changes) {
            if (supplier.contains(change)) continue;
            supplierHistory.add(change);
        }
    }

    private String[] getNewChanges(String reference, PushTarget target) {
        Entry entry = (Entry)this.entries.get((Object)reference);
        if (entry == null) {
            return null;
        }
        List supplierHistory = (List)this.changesHistory.get((Object)entry.getSupplier());
        if (supplierHistory == null || supplierHistory.size() == 0) {
            return null;
        }
        String change = this.getLastChange(reference, target);
        int lastIndex = supplierHistory.lastIndexOf(change);
        if (lastIndex < 0 || lastIndex >= supplierHistory.size() - 1) {
            return new String[0];
        }
        List newChanges = supplierHistory.subList(lastIndex + 1, supplierHistory.size());
        return newChanges.toArray(new String[0]);
    }

    private void setPushedChanges(String reference, PushTarget target, String[] changes) {
        if (changes == null || changes.length == 0) {
            return;
        }
        Entry entry = (Entry)this.entries.get((Object)reference);
        if (entry == null) {
            return;
        }
        List supplierHistory = (List)this.changesHistory.get((Object)entry.getSupplier());
        if (supplierHistory == null || supplierHistory.size() == 0) {
            throw new IllegalStateException("No changes history");
        }
        String last = changes[changes.length - 1];
        this.setLastChange(reference, target, last);
    }

    private String getLastChange(String reference, PushTarget target) {
        return (String)this.lastChanges.get((Object)this.getLastChangeKey(reference, target));
    }

    private String setLastChange(String reference, PushTarget target, String last) {
        return (String)this.lastChanges.put((Object)this.getLastChangeKey(reference, target), (Object)last);
    }

    private void createLastChange(String reference, Entry entry) {
        if (entry == null || reference == null || entry.getPushTargets() == null) {
            return;
        }
        List supplierHistory = (List)this.changesHistory.get((Object)entry.getSupplier());
        if (supplierHistory == null || supplierHistory.size() == 0) {
            return;
        }
        String last = (String)supplierHistory.get(supplierHistory.size() - 1);
        for (PushTarget t : entry.getPushTargets()) {
            if (this.getLastChange(reference, t) != null) continue;
            this.setLastChange(reference, t, last);
        }
    }

    private String getLastChangeKey(String reference, PushTarget target) {
        return reference + "-" + target.toString();
    }

    private static class Entry
    implements Serializable {
        private final String supplier;
        private final UpdateMethodEnum updateMethod;
        private final List<PushTarget> pushTargets;
        private final Calendar startTime;
        private final Calendar stopTime;
        private final Float periodSeconds;

        public Entry(String supplier, UpdateMethodEnum updateMethod, List<PushTarget> pushTargets, Calendar startTime, Calendar stopTime, Float periodSeconds) {
            this.supplier = supplier;
            this.updateMethod = updateMethod;
            this.pushTargets = Collections.unmodifiableList(pushTargets);
            this.startTime = startTime;
            this.stopTime = stopTime;
            this.periodSeconds = periodSeconds;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public UpdateMethodEnum getUpdateMethod() {
            return this.updateMethod;
        }

        public List<PushTarget> getPushTargets() {
            return this.pushTargets;
        }

        public Calendar getStartTime() {
            return this.startTime;
        }

        public Calendar getStopTime() {
            return this.stopTime;
        }

        public Float getPeriodSeconds() {
            return this.periodSeconds;
        }
    }

    private class Task
    implements Runnable {
        private final String reference;

        public Task(String reference) {
            this.reference = reference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Subscriptions.this.execute(this.reference);
            }
            finally {
                Subscriptions.this.db.commit();
            }
        }
    }
}

