/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.providers;

import cz.cdv.datex2.providers.ParkingStatusPublicationProvider;
import eu.datex2.schema._2._2_0.CountryEnum;
import eu.datex2.schema._2._2_0.ParkingRecordStatus;
import eu.datex2.schema._2._2_0.ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus;
import eu.datex2.schema._2._2_0.ParkingRecordVersionedReference;
import eu.datex2.schema._2._2_0.ParkingSiteStatus;
import eu.datex2.schema._2._2_0.ParkingSpaceStatus;
import eu.datex2.schema._2._2_0.ParkingTable;
import eu.datex2.schema._2._2_0.ParkingTableVersionedReference;
import eu.datex2.schema._2._2_0.UpdateMethodEnum;
import java.util.List;

public abstract class ParkingSpacesStatusPublicationProvider
extends ParkingStatusPublicationProvider {
    protected ParkingSpacesStatusPublicationProvider(CountryEnum country, String nationalIdentifier, String lang) {
        super(country, nationalIdentifier, lang);
    }

    @Override
    protected void fillParkingStatus(List<ParkingTableVersionedReference> tableRefList, List<ParkingRecordStatus> statusList) {
        this.cache();
        String tableId = this.getParkingTableId();
        String tableVersion = this.getParkingTableVersion();
        ParkingTableVersionedReference tableRef = new ParkingTableVersionedReference();
        tableRefList.add(tableRef);
        tableRef.setTargetClass(ParkingTable.class.getName());
        tableRef.setId(tableId);
        tableRef.setVersion(tableVersion);
        for (String siteId : this.getParkingSitesIds()) {
            ParkingSiteStatus siteStatus = new ParkingSiteStatus();
            this.fillParkingSiteStatus(siteStatus);
            statusList.add(siteStatus);
            ParkingRecordVersionedReference parkingRecordRef = new ParkingRecordVersionedReference();
            parkingRecordRef.setId(this.getParkingRecordId(siteId));
            parkingRecordRef.setVersion(this.getParkingRecordVersion(siteId));
            siteStatus.setParkingRecordReference(parkingRecordRef);
            List<ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus> spacesStatus = siteStatus.getParkingSpaceStatus();
            for (int index : this.getParkingSpaceIndices(siteId)) {
                boolean occupied = this.isParkingSpaceOccupied(siteId, index);
                ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus spaceStatus = this.getParkingSpaceStatus(siteId, index, occupied);
                spacesStatus.add(spaceStatus);
            }
        }
        this.clearCache();
    }

    @Override
    protected void fillParkingStatusChanges(List<ParkingTableVersionedReference> tableRefList, List<ParkingRecordStatus> statusList, UpdateMethodEnum updateMethod, String ... changes) {
        boolean all;
        if (changes == null || changes.length == 0) {
            throw new IllegalArgumentException("At least one change must be specified");
        }
        if (updateMethod != UpdateMethodEnum.ALL_ELEMENT_UPDATE && updateMethod != UpdateMethodEnum.SINGLE_ELEMENT_UPDATE) {
            throw new IllegalArgumentException("Unsupported update method: " + (Object)((Object)updateMethod));
        }
        boolean bl = all = updateMethod == UpdateMethodEnum.ALL_ELEMENT_UPDATE;
        if (all) {
            this.cache();
        }
        this.cacheChanges(changes);
        String tableId = this.getParkingTableId();
        String tableVersion = this.getParkingTableVersion();
        ParkingTableVersionedReference tableRef = new ParkingTableVersionedReference();
        tableRefList.add(tableRef);
        tableRef.setTargetClass(ParkingTable.class.getName());
        tableRef.setId(tableId);
        tableRef.setVersion(tableVersion);
        for (String siteId : this.getChangedParkingSitesIds(changes)) {
            ParkingSiteStatus siteStatus = new ParkingSiteStatus();
            if (all) {
                this.fillParkingSiteStatus(siteStatus);
            }
            statusList.add(siteStatus);
            ParkingRecordVersionedReference parkingRecordRef = new ParkingRecordVersionedReference();
            parkingRecordRef.setId(this.getParkingRecordId(siteId));
            parkingRecordRef.setVersion(this.getParkingRecordVersion(siteId));
            siteStatus.setParkingRecordReference(parkingRecordRef);
            List<ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus> spacesStatus = siteStatus.getParkingSpaceStatus();
            int[] spaceIndices = all ? this.getParkingSpaceIndices(siteId) : this.getChangedParkingSpaceIndices(siteId, changes);
            for (int index : spaceIndices) {
                boolean occupied = all ? this.isParkingSpaceOccupied(siteId, index) : this.isChangedParkingSpaceOccupied(siteId, index, changes);
                ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus spaceStatus = this.getParkingSpaceStatus(siteId, index, occupied);
                spacesStatus.add(spaceStatus);
            }
        }
        this.clearCacheChanges(changes);
        if (all) {
            this.clearCache();
        }
    }

    protected void cache() {
    }

    protected void clearCache() {
    }

    protected void cacheChanges(String ... changes) {
    }

    protected void clearCacheChanges(String ... changes) {
    }

    protected abstract String getParkingTableId();

    protected abstract String getParkingTableVersion();

    protected abstract String getParkingRecordId(String var1);

    protected abstract String getParkingRecordVersion(String var1);

    protected abstract String[] getParkingSitesIds();

    protected abstract int[] getParkingSpaceIndices(String var1);

    protected abstract boolean isParkingSpaceOccupied(String var1, int var2);

    protected abstract String[] getChangedParkingSitesIds(String ... var1);

    protected abstract int[] getChangedParkingSpaceIndices(String var1, String ... var2);

    protected abstract boolean isChangedParkingSpaceOccupied(String var1, int var2, String ... var3);

    protected void fillParkingSiteStatus(ParkingSiteStatus siteStatus) {
    }

    protected ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus getParkingSpaceStatus(String siteId, int index, boolean occupied) {
        ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus spaceStatus = new ParkingRecordStatusParkingSpaceIndexParkingSpaceStatus();
        spaceStatus.setParkingSpaceIndex(index);
        ParkingSpaceStatus status = new ParkingSpaceStatus();
        status.setParkingSpaceOccupied(occupied);
        spaceStatus.setParkingSpaceStatus(status);
        return spaceStatus;
    }
}

