/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.providers;

import cz.cdv.datex2.providers.ChangesProvider;
import cz.cdv.datex2.providers.PayloadPublicationProvider;
import eu.datex2.schema._2._2_0.CountryEnum;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.GenericPublication;
import eu.datex2.schema._2._2_0.GenericPublicationExtensionType;
import eu.datex2.schema._2._2_0.InternationalIdentifier;
import eu.datex2.schema._2._2_0.ParkingRecordStatus;
import eu.datex2.schema._2._2_0.ParkingStatusPublication;
import eu.datex2.schema._2._2_0.ParkingTablePublication;
import eu.datex2.schema._2._2_0.ParkingTableVersionedReference;
import eu.datex2.schema._2._2_0.PayloadPublication;
import eu.datex2.schema._2._2_0.UpdateMethodEnum;
import java.util.GregorianCalendar;
import java.util.List;

public abstract class ParkingStatusPublicationProvider
extends PayloadPublicationProvider
implements ChangesProvider {
    private String lang;
    public static final String GENERIC_PUBLICATION_NAME = ParkingTablePublication.class.getSimpleName();

    protected ParkingStatusPublicationProvider(CountryEnum country, String nationalIdentifier, String lang) {
        super(country, nationalIdentifier);
        this.lang = lang;
    }

    @Override
    protected PayloadPublication getPayloadPublication() {
        GenericPublication gp = this.createGenericPublication();
        ParkingStatusPublication parkingStatusPublication = this.createParkingStatusPublication(gp);
        List<ParkingTableVersionedReference> tableRefList = parkingStatusPublication.getParkingTableReference();
        List<ParkingRecordStatus> statusList = parkingStatusPublication.getParkingRecordStatus();
        this.fillParkingStatus(tableRefList, statusList);
        return gp;
    }

    protected ParkingStatusPublication createParkingStatusPublication(GenericPublication gp) {
        GenericPublicationExtensionType extension = new GenericPublicationExtensionType();
        ParkingStatusPublication parkingStatusPublication = new ParkingStatusPublication();
        extension.setParkingStatusPublication(parkingStatusPublication);
        gp.setGenericPublicationExtension(extension);
        return parkingStatusPublication;
    }

    protected GenericPublication createGenericPublication() {
        GenericPublication gp = new GenericPublication();
        gp.setLang(this.lang);
        gp.setGenericPublicationName(GENERIC_PUBLICATION_NAME);
        gp.setPublicationTime(new GregorianCalendar());
        InternationalIdentifier intId = new InternationalIdentifier();
        intId.setCountry(this.getCountry());
        intId.setNationalIdentifier(this.getNationalIdentifier());
        gp.setPublicationCreator(intId);
        return gp;
    }

    protected abstract void fillParkingStatus(List<ParkingTableVersionedReference> var1, List<ParkingRecordStatus> var2);

    @Override
    public D2LogicalModel getChanges(UpdateMethodEnum updateMethod, String ... changes) {
        D2LogicalModel model = this.createModel();
        model.setPayloadPublication(this.getChangesPayloadPublication(updateMethod, changes));
        return model;
    }

    protected PayloadPublication getChangesPayloadPublication(UpdateMethodEnum updateMethod, String ... changes) {
        GenericPublication gp = this.createGenericPublication();
        ParkingStatusPublication parkingStatusPublication = this.createParkingStatusPublication(gp);
        List<ParkingTableVersionedReference> tableRefList = parkingStatusPublication.getParkingTableReference();
        List<ParkingRecordStatus> statusList = parkingStatusPublication.getParkingRecordStatus();
        this.fillParkingStatusChanges(tableRefList, statusList, updateMethod, changes);
        return gp;
    }

    protected abstract void fillParkingStatusChanges(List<ParkingTableVersionedReference> var1, List<ParkingRecordStatus> var2, UpdateMethodEnum var3, String ... var4);
}

