/*
 * Decompiled with CFR 0.152.
 */
package cz.cdv.datex2.providers;

import cz.cdv.datex2.providers.SnapshotProvider;
import eu.datex2.schema._2._2_0.CountryEnum;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.Exchange;
import eu.datex2.schema._2._2_0.InternationalIdentifier;
import eu.datex2.schema._2._2_0.PayloadPublication;

public abstract class PayloadPublicationProvider
implements SnapshotProvider {
    private final CountryEnum country;
    private final String nationalIdentifier;

    protected PayloadPublicationProvider(CountryEnum country, String nationalIdentifier) {
        this.country = country;
        this.nationalIdentifier = nationalIdentifier;
    }

    @Override
    public D2LogicalModel getSnapshot() {
        D2LogicalModel model = this.createModel();
        model.setPayloadPublication(this.getPayloadPublication());
        return model;
    }

    protected D2LogicalModel createModel() {
        D2LogicalModel model = new D2LogicalModel();
        model.setModelBaseVersion("2");
        Exchange exchange = new Exchange();
        InternationalIdentifier intId = new InternationalIdentifier();
        intId.setCountry(this.country);
        intId.setNationalIdentifier(this.nationalIdentifier);
        exchange.setSupplierIdentification(intId);
        model.setExchange(exchange);
        return model;
    }

    protected abstract PayloadPublication getPayloadPublication();

    protected CountryEnum getCountry() {
        return this.country;
    }

    protected String getNationalIdentifier() {
        return this.nationalIdentifier;
    }
}

