/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.bc;

import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BouncyCastleSymmetricEngine
implements EncryptionEngine {
    private final BlockCipher cipher;
    private final KeyParameter keyParam;

    public BouncyCastleSymmetricEngine(BlockCipher cipher, KeyParameter keyParam) {
        this.cipher = cipher;
        this.keyParam = keyParam;
    }

    public byte[] encrypt(byte[] input, byte[] initVector) throws EncryptionException {
        return this.doOperation(input, initVector, true);
    }

    public byte[] decrypt(byte[] input, byte[] initVector) throws EncryptionException {
        return this.doOperation(input, initVector, false);
    }

    private byte[] doOperation(byte[] input, byte[] initVector, boolean isEncrypt) {
        ParametersWithIV params = new ParametersWithIV((CipherParameters)this.keyParam, initVector);
        PKCS7Padding padding = new PKCS7Padding();
        CBCBlockCipher engine = new CBCBlockCipher(this.cipher);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)engine, (BlockCipherPadding)padding);
        cipher.init(isEncrypt, (CipherParameters)params);
        byte[] output = new byte[cipher.getOutputSize(input.length)];
        int length = cipher.processBytes(input, 0, input.length, output, 0);
        try {
            length += cipher.doFinal(output, length);
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException("Encryption fails", (Throwable)e);
        }
        byte[] out = new byte[length];
        System.arraycopy(output, 0, out, 0, length);
        return out;
    }
}

