/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.bc;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionEngine;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class BouncyCastleSymmetricEngine
implements StreamingEncryptionEngine {
    private final Class<? extends BlockCipher> blockCipherClass;
    private final KeyParameter keyParam;

    public BouncyCastleSymmetricEngine(Class<? extends BlockCipher> blockCipherClass, KeyParameter keyParam) {
        this.blockCipherClass = blockCipherClass;
        this.keyParam = keyParam;
    }

    public byte[] encrypt(byte[] input, byte[] initVector) throws EncryptionException {
        return this.doOperation(input, initVector, true);
    }

    public byte[] decrypt(byte[] input, byte[] initVector) throws EncryptionException {
        return this.doOperation(input, initVector, false);
    }

    public InputStream encrypt(InputStream input, byte[] initVector) throws EncryptionException {
        BufferedBlockCipher cipher = this.createCipher(initVector, true);
        return new CipherInputStream(input, cipher);
    }

    public OutputStream encrypt(OutputStream output, byte[] initVector) {
        BufferedBlockCipher cipher = this.createCipher(initVector, true);
        return new CipherOutputStream(output, cipher);
    }

    public InputStream decrypt(InputStream input, byte[] initVector) {
        BufferedBlockCipher cipher = this.createCipher(initVector, false);
        return new CipherInputStream(input, cipher);
    }

    public OutputStream decrypt(OutputStream output, byte[] initVector) throws EncryptionException {
        BufferedBlockCipher cipher = this.createCipher(initVector, false);
        return new CipherOutputStream(output, cipher);
    }

    private BufferedBlockCipher createCipher(byte[] initVector, boolean isEncrypt) {
        BlockCipher blockCipher;
        ParametersWithIV params = new ParametersWithIV((CipherParameters)this.keyParam, initVector);
        PKCS7Padding padding = new PKCS7Padding();
        try {
            blockCipher = this.blockCipherClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new EncryptionException("Encryption fails", (Throwable)e);
        }
        CBCBlockCipher engine = new CBCBlockCipher(blockCipher);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)engine, (BlockCipherPadding)padding);
        cipher.init(isEncrypt, (CipherParameters)params);
        return cipher;
    }

    private byte[] doOperation(byte[] input, byte[] initVector, boolean isEncrypt) {
        BufferedBlockCipher cipher = this.createCipher(initVector, isEncrypt);
        byte[] output = new byte[cipher.getOutputSize(input.length)];
        int length = cipher.processBytes(input, 0, input.length, output, 0);
        try {
            length += cipher.doFinal(output, length);
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException("Encryption fails", (Throwable)e);
        }
        byte[] out = new byte[length];
        System.arraycopy(output, 0, out, 0, length);
        return out;
    }
}

