/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.ByteArrayFactory;
import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombiningSplitting;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;

public final class GenericEncryptionAlgorithm
implements EncryptionAlgorithm {
    private final boolean usesInitVector;
    private final EncryptionEngine engine;
    private final int blockSize;
    private final ByteArrayFactory ivFactory;
    private final CombiningSplitting ivOutputCombining;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    GenericEncryptionAlgorithm(EncryptionEngine engine, BytesRepresentation bytesRepresentation, String encoding, int blockSize, ByteArrayFactory ivFactory, CombiningSplitting ivOutputCombining) throws EncryptionException {
        this.engine = engine;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        this.usesInitVector = true;
        this.blockSize = blockSize;
        this.ivFactory = ivFactory;
        this.ivOutputCombining = ivOutputCombining;
    }

    protected GenericEncryptionAlgorithm(EncryptionEngine engine, BytesRepresentation bytesRepresentation, String encoding) throws EncryptionException {
        this.engine = engine;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        this.usesInitVector = false;
        this.blockSize = -1;
        this.ivFactory = null;
        this.ivOutputCombining = null;
    }

    @Override
    public byte[] encrypt(byte[] input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for encryption cannot be null!");
        }
        if (this.usesInitVector) {
            byte[] iv = this.getIv();
            byte[] encryptedBytes = this.engine.encrypt(input, iv);
            return this.ivOutputCombining.combine(iv, encryptedBytes);
        }
        return this.engine.encrypt(input, null);
    }

    @Override
    public String encrypt(String input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for encryption cannot be null!");
        }
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] encryptedBytes = this.encrypt(textBytes);
        return this.bytesRepresentation.toString(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for decryption cannot be null!");
        }
        if (this.usesInitVector) {
            byte[][] ivAndCipherText = this.ivOutputCombining.split(input);
            if (ivAndCipherText == null || ivAndCipherText.length != 2) {
                throw new EncryptionException("Splitting of input into two parts during decryption produced wrong number of parts. Is the input or used implementation of CombiningSplitting correct?");
            }
            return this.engine.decrypt(ivAndCipherText[1], ivAndCipherText[0]);
        }
        return this.engine.decrypt(input, null);
    }

    @Override
    public String decrypt(String input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for decryption cannot be null!");
        }
        byte[] textBytes = this.bytesRepresentation.toBytes(input);
        byte[] decryptedBytes = this.decrypt(textBytes);
        return Encoding.getString(decryptedBytes, this.encoding);
    }

    private byte[] getIv() {
        byte[] ivBytes = this.ivFactory.getBytes(this.blockSize);
        if (ivBytes.length != this.blockSize) {
            throw new IllegalArgumentException("Generated initialization vector has size " + ivBytes.length + " bytes but must be size equal to block size " + this.blockSize + " bytes");
        }
        return ivBytes;
    }
}

