/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.ByteArray;
import cz.d1x.dxcrypto.common.ByteArrayFactory;
import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombiningSplitting;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.common.RandomByteArrayFactory;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.EncryptionFactories;
import cz.d1x.dxcrypto.encryption.GenericEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.key.DerivedKeyParams;
import cz.d1x.dxcrypto.encryption.key.EncryptionKeyFactory;

public final class SymmetricAlgorithmBuilder {
    private static final byte[] DEFAULT_KEY_SALT = new byte[]{39, 17, 101, 53, 19, 119, 51, 33, 64, 67, 24, 101};
    private static final int DEFAULT_KEY_HASH_ITERATIONS = 4096;
    private final EncryptionFactories factories;
    private final int keySize;
    private final int blockSize;
    private EncryptionKeyFactory<ByteArray, DerivedKeyParams> keyFactory = null;
    private byte[] key;
    private byte[] keyPassword;
    private SymmetricEncryptionEngineFactory<ByteArray> engineFactory;
    private byte[] keySalt = DEFAULT_KEY_SALT;
    private int keyHashIterations = 4096;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";
    private ByteArrayFactory ivFactory;
    private CombiningSplitting ivOutputCombining;

    public SymmetricAlgorithmBuilder(EncryptionFactories factories, SymmetricEncryptionEngineFactory<ByteArray> engineFactory, int keySize, int blockSize) {
        this.factories = factories;
        this.engineFactory = engineFactory;
        this.keySize = keySize;
        this.blockSize = blockSize / 8;
        this.ivOutputCombining = new ConcatAlgorithm(this.blockSize);
        this.ivFactory = new RandomByteArrayFactory();
    }

    public SymmetricAlgorithmBuilder engineFactory(SymmetricEncryptionEngineFactory<ByteArray> engineFactory) throws IllegalArgumentException {
        if (engineFactory == null) {
            throw new IllegalArgumentException("You must provide non-null engine factory!");
        }
        this.engineFactory = engineFactory;
        return this;
    }

    public SymmetricAlgorithmBuilder key(byte[] key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        if (key.length != this.keySize / 8) {
            throw new IllegalArgumentException("Invalid key size, is " + key.length + " bytes but must be " + this.keySize / 8 + "bytes");
        }
        this.key = key;
        this.keyFactory = null;
        this.keyPassword = null;
        return this;
    }

    public SymmetricAlgorithmBuilder keyPassword(byte[] keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        this.keyPassword = keyPassword;
        this.key = null;
        return this;
    }

    public SymmetricAlgorithmBuilder keyPassword(String keyPassword) throws IllegalArgumentException {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        return this.keyPassword(Encoding.getBytes(keyPassword));
    }

    public SymmetricAlgorithmBuilder keySalt(byte[] keySalt) throws IllegalArgumentException {
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        this.keySalt = keySalt;
        return this;
    }

    public SymmetricAlgorithmBuilder keySalt(String keySalt) throws IllegalArgumentException {
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        return this.keySalt(Encoding.getBytes(keySalt));
    }

    public SymmetricAlgorithmBuilder keyHashIterations(int keyHashIterations) throws IllegalArgumentException {
        if (keyHashIterations < 1) {
            throw new IllegalArgumentException("You must provide iterations >= 1!");
        }
        this.keyHashIterations = keyHashIterations;
        return this;
    }

    public SymmetricAlgorithmBuilder keyDerivation(byte[] keyPassword, byte[] keySalt, int keyHashIterations) throws IllegalArgumentException {
        this.keyPassword(keyPassword);
        this.keySalt(keySalt);
        this.keyHashIterations(keyHashIterations);
        return this;
    }

    public SymmetricAlgorithmBuilder keyFactory(EncryptionKeyFactory<ByteArray, DerivedKeyParams> keyFactory) throws IllegalArgumentException {
        if (keyFactory == null) {
            throw new IllegalArgumentException("You must provide non-null key factory!");
        }
        this.keyFactory = keyFactory;
        this.key = null;
        return this;
    }

    public SymmetricAlgorithmBuilder ivFactory(ByteArrayFactory ivFactory) throws IllegalArgumentException {
        if (ivFactory == null) {
            throw new IllegalArgumentException("You must provide non-null ByteArrayFactory!");
        }
        this.ivFactory = ivFactory;
        return this;
    }

    public SymmetricAlgorithmBuilder ivAndOutputCombining(CombiningSplitting ivOutputCombining) throws IllegalArgumentException {
        if (ivOutputCombining == null) {
            throw new IllegalArgumentException("You must provide non-null CombiningSplitting!");
        }
        this.ivOutputCombining = ivOutputCombining;
        return this;
    }

    public SymmetricAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) throws IllegalArgumentException {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public SymmetricAlgorithmBuilder encoding(String encoding) throws IllegalArgumentException {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public EncryptionAlgorithm build() throws IllegalArgumentException {
        DerivedKeyParams keyParams = new DerivedKeyParams(this.keyPassword, this.keySalt, this.keyHashIterations, this.keySize);
        ByteArray key = this.resolveKeyFactory().newKey(keyParams);
        EncryptionEngine engine = this.engineFactory.newEngine(key);
        return new GenericEncryptionAlgorithm(engine, this.bytesRepresentation, this.encoding, this.blockSize, this.ivFactory, this.ivOutputCombining);
    }

    private EncryptionKeyFactory<ByteArray, DerivedKeyParams> resolveKeyFactory() {
        if (this.key != null && this.key.length != 0) {
            return new EncryptionKeyFactory<ByteArray, DerivedKeyParams>(){

                @Override
                public ByteArray newKey(DerivedKeyParams keyParams) throws EncryptionException {
                    return new ByteArray(SymmetricAlgorithmBuilder.this.key);
                }
            };
        }
        if (this.keyFactory != null) {
            return this.keyFactory;
        }
        if (this.keyPassword != null && this.keyPassword.length != 0) {
            return this.factories.derivedKeyFactory();
        }
        throw new IllegalArgumentException("Missing data for encryption key (at least one of these must be set: keyFactory, keyPassword, key)");
    }
}

