/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.common.ByteArray;
import cz.d1x.dxcrypto.encryption.AsymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.EncryptionFactories;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoPBKDF2KeyFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoRSAEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoSymmetricEngineFactory;
import cz.d1x.dxcrypto.encryption.key.DerivedKeyParams;
import cz.d1x.dxcrypto.encryption.key.EncryptionKeyFactory;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public class CryptoFactories
implements EncryptionFactories {
    @Override
    public EncryptionKeyFactory<ByteArray, DerivedKeyParams> derivedKeyFactory() {
        return new CryptoPBKDF2KeyFactory();
    }

    @Override
    public SymmetricEncryptionEngineFactory<ByteArray> aes() {
        return new CryptoSymmetricEngineFactory("AES/CBC/PKCS5Padding");
    }

    @Override
    public SymmetricEncryptionEngineFactory<ByteArray> aes256() {
        this.checkJCE("AES", 256);
        return new CryptoSymmetricEngineFactory("AES/CBC/PKCS5Padding");
    }

    @Override
    public SymmetricEncryptionEngineFactory<ByteArray> tripleDes() {
        return new CryptoSymmetricEngineFactory("DESede/CBC/PKCS5Padding");
    }

    @Override
    public AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> rsa() {
        return new CryptoRSAEngineFactory("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
    }

    private void checkJCE(String name, int keySize) {
        IllegalArgumentException exc = new IllegalArgumentException("Cipher " + name + " is not supported with key size of " + keySize + "b,  probably Java Cryptography Extension (JCE) is not installed in your Java.");
        try {
            if (Cipher.getMaxAllowedKeyLength(name) < keySize) {
                throw exc;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw exc;
        }
    }
}

