/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.common.ByteArray;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.key.DerivedKeyParams;
import cz.d1x.dxcrypto.encryption.key.EncryptionKeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class CryptoPBKDF2KeyFactory
implements EncryptionKeyFactory<ByteArray, DerivedKeyParams> {
    @Override
    public ByteArray newKey(DerivedKeyParams keyParams) {
        char[] keyEncoded = Encoding.getString(keyParams.getPassword()).toCharArray();
        PBEKeySpec keySpec = new PBEKeySpec(keyEncoded, keyParams.getSalt(), keyParams.getIterations(), keyParams.getKeySize());
        try {
            SecretKey key = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(keySpec);
            return new ByteArray(key.getEncoded());
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Key cannot be created", e);
        }
    }
}

