/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Combining;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.RepeatingDecoratorBuilder;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;

public abstract class HashingAlgorithmBuilder {
    protected BytesRepresentation bytesRepresentation = new HexRepresentation();
    protected String encoding = "UTF-8";

    protected HashingAlgorithmBuilder() {
    }

    public HashingAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) throws IllegalArgumentException {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public HashingAlgorithmBuilder encoding(String encoding) throws IllegalArgumentException {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.bytesRepresentation, this.encoding);
    }

    public SaltingAdapterBuilder salted(Combining combining) throws IllegalArgumentException {
        if (combining == null) {
            throw new IllegalArgumentException("You must provide non-null Combining!");
        }
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.bytesRepresentation, this.encoding).inputAndSaltCombining(combining);
    }

    public RepeatingDecoratorBuilder repeated(int repeats) throws IllegalArgumentException {
        if (repeats < 1) {
            throw new IllegalArgumentException("You must provide repeats >= 1!");
        }
        HashingAlgorithm alg = this.build();
        return new RepeatingDecoratorBuilder(alg, this.bytesRepresentation, this.encoding).repeats(repeats);
    }

    public abstract HashingAlgorithm build();
}

