/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Combining;
import cz.d1x.dxcrypto.common.CombiningSplitting;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithms;
import cz.d1x.dxcrypto.encryption.EncryptionFactories;
import cz.d1x.dxcrypto.encryption.RSAKeysGenerator;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithms;
import cz.d1x.dxcrypto.hash.RepeatingDecorator;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;
import cz.d1x.dxcrypto.props.SecureProperties;
import java.math.BigInteger;

public class ReadMeExamples {
    public void hashing() {
        HashingAlgorithm sha256 = HashingAlgorithms.sha256().build();
        byte[] hashedBytes = sha256.hash(new byte[]{104, 101, 108, 108, 111});
        String hashedString = sha256.hash("hello");
        RepeatingDecorator customizedSha512 = HashingAlgorithms.sha512().encoding("UTF-8").bytesRepresentation((BytesRepresentation)new HexRepresentation(true)).repeated(27).build();
        SaltedHashingAlgorithm saltedSha1 = HashingAlgorithms.sha1().salted().build();
        String salted = saltedSha1.hash("your input text", "your salt");
        ConcatAlgorithm combining = new ConcatAlgorithm();
        SaltedHashingAlgorithm customSaltedSha256 = HashingAlgorithms.sha256().salted((Combining)combining).build();
    }

    public void symmetricEncryption() {
        StreamingEncryptionAlgorithm aes = EncryptionAlgorithms.aes((String)"secretPassword").build();
        byte[] encryptedBytes = aes.encrypt(new byte[]{104, 101, 108, 108, 111});
        byte[] decryptedBytes = aes.decrypt(encryptedBytes);
        String encryptedString = aes.encrypt("hello");
        String decryptedString = aes.decrypt(encryptedString);
        StreamingEncryptionAlgorithm customizedAes = EncryptionAlgorithms.aes((String)"secretPassphrase").keySalt("saltForKeyDerivation").keyHashIterations(4096).ivAndOutputCombining((CombiningSplitting)new ConcatAlgorithm()).bytesRepresentation((BytesRepresentation)new HexRepresentation(true)).build();
        byte[] key = new byte[16];
        StreamingEncryptionAlgorithm customKeyAes = EncryptionAlgorithms.aes().key(key).build();
    }

    public void asymmetricEncryption() {
        BigInteger modulus = BigInteger.ONE;
        BigInteger publicExponent = BigInteger.ONE;
        BigInteger privateExponent = BigInteger.ONE;
        EncryptionAlgorithm rsa = EncryptionAlgorithms.rsa().publicKey(modulus, publicExponent).privateKey(modulus, privateExponent).build();
        RSAKeysGenerator keysGen = new RSAKeysGenerator();
        RSAKeyParams[] keys = keysGen.generateKeys();
        EncryptionAlgorithm genRsa = EncryptionAlgorithms.rsa().publicKey(keys[0].getModulus(), keys[0].getExponent()).privateKey(keys[1].getModulus(), keys[1].getExponent()).build();
    }

    public void customEngines() {
        SymmetricEncryptionEngineFactory customFactory = null;
        StreamingEncryptionAlgorithm customAes = EncryptionAlgorithms.aes((String)"secretPassphrase").engineFactory(customFactory).build();
        EncryptionFactories factories = null;
        EncryptionAlgorithms.defaultFactories(factories);
        StreamingEncryptionAlgorithm customAes256 = EncryptionAlgorithms.aes256((String)"secretPassphrase").build();
    }

    public void secureProperties() {
        StreamingEncryptionAlgorithm algorithm = EncryptionAlgorithms.aes((String)"whatever").build();
        SecureProperties props = new SecureProperties((EncryptionAlgorithm)algorithm);
        props.setProperty("plainProperty", "imGoodBoy");
        props.setEncryptedProperty("encryptedProperty", "myDirtySecret");
        String decrypted = props.getProperty("encryptedProperty");
        String original = props.getOriginalProperty("encryptedProperty");
    }
}

