/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.encryption.BaseEncryptionTests;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithms;
import cz.d1x.dxcrypto.encryption.EncryptionFactories;
import cz.d1x.dxcrypto.encryption.RSAKeysGenerator;
import cz.d1x.dxcrypto.encryption.crypto.CryptoFactories;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.BeforeClass;
import org.junit.Test;

public class CoreEncryptionTests
extends BaseEncryptionTests {
    private static final byte[] AES_KEY = new byte[]{39, 24, 39, 9, 124, 68, 23, 30, 67, 3, 17, 39, 31, 13, 109, 100};
    private static final byte[] TRIPLE_DES_KEY = new byte[]{39, 24, 39, 9, 124, 68, 23, 30, 67, 3, 17, 39, 31, 13, 109, 100, 68, 24, 39, 9, 122, 68, 23, 62};
    private static final RSAKeyParams[] RSA_KEYS = new RSAKeysGenerator().generateKeys();

    @BeforeClass
    public static void setupFactories() {
        EncryptionAlgorithms.defaultFactories((EncryptionFactories)new CryptoFactories());
    }

    @Override
    protected Collection<EncryptionAlgorithm> getAlgorithmsToTest() {
        return new ArrayList<EncryptionAlgorithm>(){
            {
                this.add(EncryptionAlgorithms.aes((byte[])AES_KEY).build());
                this.add(EncryptionAlgorithms.tripleDes((byte[])TRIPLE_DES_KEY).build());
                this.add(EncryptionAlgorithms.rsa().publicKey(RSA_KEYS[0].getModulus(), RSA_KEYS[0].getExponent()).privateKey(RSA_KEYS[1].getModulus(), RSA_KEYS[1].getExponent()).build());
            }
        };
    }

    @Override
    @Test
    public void nullInputsThrowEncryptionException() {
        super.nullInputsThrowEncryptionException();
    }

    @Override
    @Test
    public void encryptedInputCanBeCorrectlyDecrypted() {
        super.encryptedInputCanBeCorrectlyDecrypted();
    }

    @Override
    @Test
    public void byteAndStringBasedMethodsGiveSameOutput() {
        super.byteAndStringBasedMethodsGiveSameOutput();
    }

    @Override
    @Test
    public void sameInputsHaveDifferentOutputsForSymmetricAlgorithms() {
        super.sameInputsHaveDifferentOutputsForSymmetricAlgorithms();
    }

    @Override
    @Test
    public void encryptedInputStreamCanBeCorrectlyDecrypted() {
        super.encryptedInputStreamCanBeCorrectlyDecrypted();
    }

    @Override
    @Test
    public void encryptedOutputStreamCanBeCorrectlyDecrypted() {
        super.encryptedOutputStreamCanBeCorrectlyDecrypted();
    }

    @Override
    @Test
    public void concurrentEncryptingThreadsDoesNotInterfere() {
        super.concurrentEncryptingThreadsDoesNotInterfere();
    }
}

