/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.TestResult;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionTest;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class EncryptedInputCanBeCorrectlyDecrypted
implements EncryptionTest {
    @Override
    public TestResult test(EncryptionAlgorithm algorithm) {
        String decrypted;
        byte[] plainBytes;
        String plain = "th1s_is_something inter3sting -*";
        try {
            plainBytes = plain.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return TestResult.fail("Unable to get bytes of UTF-8");
        }
        byte[] encryptedBytes = algorithm.encrypt(plainBytes);
        byte[] decryptedBytes = algorithm.decrypt(encryptedBytes);
        if (Arrays.equals(encryptedBytes, decryptedBytes)) {
            return TestResult.fail("Encrypted and decrypted bytes are the same");
        }
        if (!Arrays.equals(plainBytes, decryptedBytes)) {
            return TestResult.fail("Original and decrypted strings are not equal");
        }
        String encrypted = algorithm.encrypt(plain);
        if (encrypted.equals(decrypted = algorithm.decrypt(encrypted))) {
            return TestResult.fail("Encrypted and decrypted bytes are the same");
        }
        if (!plain.equals(decrypted)) {
            return TestResult.fail("Original and decrypted strings are not equal");
        }
        return TestResult.success();
    }
}

