/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.TestResult;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionTest;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class EncryptedInputStreamCanBeCorrectlyDecrypted
implements EncryptionTest {
    @Override
    public TestResult test(EncryptionAlgorithm algorithm) {
        String decryptedString;
        byte[] encryptedBytes;
        String plainString = "Som3 T@";
        if (!(algorithm instanceof StreamingEncryptionAlgorithm)) {
            return TestResult.success();
        }
        StreamingEncryptionAlgorithm streamingAlgorithm = (StreamingEncryptionAlgorithm)algorithm;
        ByteArrayInputStream input = new ByteArrayInputStream(plainString.getBytes(StandardCharsets.UTF_8));
        try (InputStream encrypted = streamingAlgorithm.encrypt((InputStream)input);){
            encryptedBytes = this.readWholeInputStream(encrypted);
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        if (new String(encryptedBytes, StandardCharsets.UTF_8).contains(plainString)) {
            return TestResult.fail("Encrypted string contains original string");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (OutputStream decrypted = streamingAlgorithm.decrypt((OutputStream)output);){
            decrypted.write(encryptedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        try (InputStream decrypted = streamingAlgorithm.decrypt((InputStream)new ByteArrayInputStream(encryptedBytes));){
            byte[] decryptedBytes = this.readWholeInputStream(decrypted);
            decryptedString = new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        if (!new String(output.toByteArray(), StandardCharsets.UTF_8).equals(plainString)) {
            return TestResult.fail("Original and decrypted strings does not match");
        }
        if (!decryptedString.equals(plainString)) {
            return TestResult.fail("Original and decrypted strings does not match");
        }
        return TestResult.success();
    }

    private byte[] readWholeInputStream(InputStream decrypted) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        do {
            read = IOUtils.read((InputStream)decrypted, (byte[])buffer);
            result.write(buffer, 0, read);
        } while (read > 0);
        return result.toByteArray();
    }
}

