/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import cz.d1x.dxcrypto.encryption.StreamingEncryptionEngine;
import cz.d1x.dxcrypto.encryption.io.DecryptingOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DecryptingOutputStreamTest {
    @Test
    public void writesUpToBlockSizeAreNotWrittenToOutput() throws IOException {
        StreamingEncryptionEngine engineMock = (StreamingEncryptionEngine)Mockito.mock(StreamingEncryptionEngine.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Mockito.when((Object)engineMock.decrypt((OutputStream)Mockito.any(OutputStream.class), (byte[])Mockito.any(byte[].class))).thenReturn((Object)output);
        DecryptingOutputStream decryptingOutputStream = new DecryptingOutputStream((OutputStream)output, engineMock, 16);
        byte[] iv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        decryptingOutputStream.write(iv);
        ((StreamingEncryptionEngine)Mockito.verify((Object)engineMock)).decrypt((OutputStream)output, iv);
        Assert.assertArrayEquals((String)"Output was written before whole IV was read.", (byte[])new byte[0], (byte[])output.toByteArray());
    }

    @Test
    public void writesAfterBlockSizeAreWrittenToOutput() throws IOException {
        StreamingEncryptionEngine engineMock = (StreamingEncryptionEngine)Mockito.mock(StreamingEncryptionEngine.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Mockito.when((Object)engineMock.decrypt((OutputStream)Mockito.any(OutputStream.class), (byte[])Mockito.any(byte[].class))).thenReturn((Object)output);
        DecryptingOutputStream decryptingOutputStream = new DecryptingOutputStream((OutputStream)output, engineMock, 16);
        decryptingOutputStream.write(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        Assert.assertArrayEquals((String)"Wrong bytes was written to output.", (byte[])new byte[]{16, 17, 18, 19, 20}, (byte[])output.toByteArray());
    }
}

