/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import cz.d1x.dxcrypto.encryption.io.EncryptingInputStream;
import cz.d1x.dxcrypto.encryption.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class EncryptingInputStreamTest {
    @Test
    public void ivAndDataAreReadedCorrectly() throws IOException {
        EncryptingInputStream input = new EncryptingInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5}), new byte[]{10, 11, 12, 13});
        byte[] buffer = new byte[10];
        Assert.assertEquals((long)10L, (long)IOUtils.read((InputStream)input, (byte[])buffer));
        Assert.assertArrayEquals((byte[])new byte[]{10, 11, 12, 13, 0, 1, 2, 3, 4, 5}, (byte[])buffer);
        Assert.assertEquals((long)-1L, (long)input.read());
    }

    @Test
    public void availableReturnsCorrectValues() throws IOException {
        EncryptingInputStream input = new EncryptingInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5}), new byte[]{10, 11, 12, 13});
        Assert.assertEquals((long)10L, (long)input.available());
        input.read();
        Assert.assertEquals((long)9L, (long)input.available());
    }

    @Test
    public void markSupportedReturnsFalse() {
        EncryptingInputStream input = new EncryptingInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5}), new byte[]{10, 11, 12, 13});
        Assert.assertFalse((boolean)input.markSupported());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void skipThrowsUnsupportedOperationException() throws IOException {
        EncryptingInputStream input = new EncryptingInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5}), new byte[]{10, 11, 12, 13});
        input.skip(10L);
    }
}

