/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.RepeatingDecorator;
import cz.d1x.dxcrypto.hash.RepeatingDecoratorBuilder;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class HashingAlgorithmTest {
    private static final int REPEATS_COUNT = 3;
    private static final String[] INPUTS = new String[]{"Toto-jePrvni.vstupPro_h@sh", "0111111111101101111111111111111111111", ""};
    private HashingAlgorithm algorithm;

    protected abstract HashingAlgorithm getAlgorithm();

    protected abstract String[] getExpectedSimpleOutputs();

    protected abstract String[] getRepeatedOutputs();

    @Before
    public void setUp() {
        this.algorithm = this.getAlgorithm();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullHashing() {
        this.algorithm.hash((String)null);
    }

    @Test
    public void simpleHashing() {
        String[] expected = this.getExpectedSimpleOutputs();
        Assert.assertEquals((String)"Expected outputs must have same length as inputs", (long)INPUTS.length, (long)expected.length);
        int i = 0;
        for (String input : INPUTS) {
            this.testHash(expected[i], this.algorithm.hash(input), i);
            ++i;
        }
    }

    @Test
    public void repeatingHashing() {
        RepeatingDecorator repeatedAlgorithm = new RepeatingDecoratorBuilder(this.algorithm, (BytesRepresentation)new HexRepresentation(), "UTF-8").repeats(3).build();
        String[] expected = this.getRepeatedOutputs();
        Assert.assertEquals((String)"Expected outputs must have same length as inputs", (long)INPUTS.length, (long)expected.length);
        int i = 0;
        for (String input : INPUTS) {
            this.testHash(expected[i], repeatedAlgorithm.hash(input), i);
            ++i;
        }
    }

    @Test
    public void saltingWithDefaultCombineStrategy() {
        SaltedHashingAlgorithm adapter = new SaltingAdapterBuilder(this.algorithm, (BytesRepresentation)new HexRepresentation(), "UTF-8").build();
        String input = INPUTS[0];
        String hash1 = adapter.hash(input, "s@Lt1");
        String hash2 = adapter.hash(input, "s@Lt2");
        Assert.assertNotEquals((String)"Same inputs with different salt must have different hash", (Object)hash1, (Object)hash2);
    }

    @Test
    public void testConcurrentHashing() {
        int threads = 1000;
        final AtomicBoolean everythingOk = new AtomicBoolean(true);
        final AtomicInteger finishedThreads = new AtomicInteger(0);
        final HashingAlgorithm algorithm = this.getAlgorithm();
        for (int i = 0; i < threads; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        algorithm.hash("Test concurrency");
                    }
                    catch (Exception ex) {
                        System.out.println("Concurrent hashing fails!");
                        everythingOk.set(false);
                    }
                    finishedThreads.incrementAndGet();
                }
            });
            thread.start();
        }
        while (finishedThreads.get() < threads) {
            try {
                Thread.sleep(100L);
                if (everythingOk.get()) continue;
                Assert.fail((String)"Any of hashing failed");
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Interrupted thread in test");
            }
        }
    }

    protected void testHash(String expectedHash, String actualHash, int idx) {
        Assert.assertNotNull((String)"Expecting non-null hash", (Object)actualHash);
        Assert.assertEquals((String)("Expecting same hashes idx=" + idx + " algorithm=" + this.algorithm.getClass().getSimpleName()), (Object)expectedHash, (Object)actualHash);
    }
}

