/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.performance;

import cz.d1x.dxcrypto.hash.HashingAlgorithms;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class HashingPerformanceTest {
    private final int ITERATIONS_COUNT = 10000;
    private final int MIN_PLAIN_TEXT_LENGTH = 10;
    private final int MAX_PLAIN_TEXT_LENGTH = 30;
    private final Random RND = new Random();

    @Test
    public void sha256Performance() {
        SaltedHashingAlgorithm alg = HashingAlgorithms.sha256().salted().build();
        long avg = this.doTest(alg, "SHA-256");
        Assert.assertTrue((String)"Expecting average hashing time lower than 50ms", (avg < 50L ? 1 : 0) != 0);
    }

    @Test
    public void sha512Performance() {
        SaltedHashingAlgorithm alg = HashingAlgorithms.sha512().salted().build();
        long avg = this.doTest(alg, "SHA-512");
        Assert.assertTrue((String)"Expecting average hashing time lower than 50ms", (avg < 50L ? 1 : 0) != 0);
    }

    private long doTest(SaltedHashingAlgorithm algorithm, String algName) {
        System.out.println("===> Starting tests of " + algName + " with plain texts of random bytes with length between [" + 10 + "," + 30 + "] and salt length " + 16);
        long minDuration = Long.MAX_VALUE;
        long maxDuration = Long.MIN_VALUE;
        long durationsSum = 0L;
        for (int i = 0; i < 10000; ++i) {
            int plainTextLength = 10 + this.RND.nextInt(20);
            byte[] plainText = new byte[plainTextLength];
            byte[] salt = new byte[16];
            this.RND.nextBytes(salt);
            this.RND.nextBytes(plainText);
            long start = System.currentTimeMillis();
            algorithm.hash(plainText, salt);
            long duration = System.currentTimeMillis() - start;
            if (duration > maxDuration) {
                maxDuration = duration;
            }
            if (duration < minDuration) {
                minDuration = duration;
            }
            durationsSum += duration;
        }
        long avgDuration = durationsSum / 10000L;
        System.out.println("===> Results of algorithm " + algName + ": AVG=" + avgDuration + "ms, MIN=" + minDuration + "ms, MAX=" + maxDuration + "ms");
        return avgDuration;
    }
}

