/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.AsymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.GenericEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.math.BigInteger;

public final class RSAAlgorithmBuilder {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> engineFactory;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";

    public RSAAlgorithmBuilder(AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> engineFactory) {
        this.engineFactory = engineFactory;
    }

    public RSAAlgorithmBuilder engineFactory(AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> engineFactory) throws IllegalArgumentException {
        if (engineFactory == null) {
            throw new IllegalArgumentException("You must provide non-null engine factory!");
        }
        this.engineFactory = engineFactory;
        return this;
    }

    public RSAAlgorithmBuilder publicKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new EncryptionException("You must provide non-null both modulus and exponent for public key!");
        }
        this.modulus = modulus;
        this.publicExponent = exponent;
        return this;
    }

    public RSAAlgorithmBuilder privateKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new IllegalArgumentException("You must provide non-null both modulus and exponent for private key");
        }
        this.modulus = modulus;
        this.privateExponent = exponent;
        return this;
    }

    public RSAAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public RSAAlgorithmBuilder encoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public EncryptionAlgorithm build() throws IllegalArgumentException {
        RSAKeyParams publicKey = this.publicExponent != null ? new RSAKeyParams(this.modulus, this.publicExponent) : null;
        RSAKeyParams privateKey = this.privateExponent != null ? new RSAKeyParams(this.modulus, this.privateExponent) : null;
        EncryptionEngine engine = this.engineFactory.newEngine(publicKey, privateKey);
        return new GenericEncryptionAlgorithm(engine, this.bytesRepresentation, this.encoding);
    }
}

