/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class RSAKeysGenerator {
    private static final int DEFAULT_KEY_SIZE = 1024;
    private final KeyPairGenerator generator;

    public RSAKeysGenerator() {
        this(1024);
    }

    public RSAKeysGenerator(int keySize) throws EncryptionException {
        try {
            this.generator = KeyPairGenerator.getInstance("RSA");
            this.generator.initialize(keySize);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize RSA keys generator, is it supported by your JRE?", e);
        }
    }

    public RSAKeyParams[] generateKeys() {
        KeyPair keyPair = this.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAKeyParams[] out = new RSAKeyParams[]{new RSAKeyParams(publicKey.getModulus(), publicKey.getPublicExponent()), new RSAKeyParams(privateKey.getModulus(), privateKey.getPrivateExponent())};
        return out;
    }

    public KeyPair generateKeyPair() {
        return this.generator.generateKeyPair();
    }

    public static class RSAKeys {
        private final BigInteger modulus;
        private final BigInteger publicExponent;
        private final BigInteger privateExponent;

        public RSAKeys(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent) {
            this.modulus = modulus;
            this.publicExponent = publicExponent;
            this.privateExponent = privateExponent;
        }

        public BigInteger getModulus() {
            return this.modulus;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public BigInteger getPrivateExponent() {
            return this.privateExponent;
        }
    }
}

