/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.encryption.AsymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.CryptoAsymmetricEngine;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class CryptoRSAEngineFactory
implements AsymmetricEncryptionEngineFactory<RSAKeyParams, RSAKeyParams> {
    private final String algorithmName;

    public CryptoRSAEngineFactory(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public EncryptionEngine newEngine(RSAKeyParams publicKey, RSAKeyParams privateKey) {
        try {
            String shortAlgorithmName = this.algorithmName.contains("/") ? this.algorithmName.substring(0, this.algorithmName.indexOf("/")) : this.algorithmName;
            KeyFactory keyFactory = KeyFactory.getInstance(shortAlgorithmName);
            PublicKey pubKey = null;
            PrivateKey privKey = null;
            if (publicKey != null) {
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(publicKey.getModulus(), publicKey.getExponent());
                pubKey = keyFactory.generatePublic(pubKeySpec);
            }
            if (privateKey != null) {
                RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(privateKey.getModulus(), privateKey.getExponent());
                privKey = keyFactory.generatePrivate(privKeySpec);
            }
            return new CryptoAsymmetricEngine(this.algorithmName, pubKey, privKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Unable to retrieve RSA public key", e);
        }
    }
}

